/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.factory;

import net.shibboleth.utilities.java.support.component.ComponentSupport;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public abstract class AbstractComponentAwareFactoryBean<T>
extends AbstractFactoryBean<T> {
    protected void destroyInstance(T instance) throws Exception {
        super.destroyInstance(instance);
        ComponentSupport.destroy(instance);
    }

    protected final T createInstance() throws Exception {
        if (!this.isSingleton()) {
            LoggerFactory.getLogger(AbstractComponentAwareFactoryBean.class).error("Configuration error: {} should not be used to create prototype beans.  Destroy is never called for prototype beans", AbstractComponentAwareFactoryBean.class);
            throw new BeanCreationException("Do not use AbstractComponentAwareFactoryBean to create prototype beans");
        }
        T theBean = this.doCreateInstance();
        ComponentSupport.initialize(theBean);
        return theBean;
    }

    protected abstract T doCreateInstance() throws Exception;
}

