/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.factory;

import java.io.InputStream;
import java.security.PrivateKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.cryptacular.util.KeyPairUtil;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

public class PrivateKeyFactoryBean
implements FactoryBean<PrivateKey> {
    private Resource resource;
    private String keyPass;
    private PrivateKey key;

    public void setResource(@Nonnull Resource res) {
        this.resource = (Resource)Constraint.isNotNull((Object)res, (String)"Private key resource can not be null");
    }

    public void setPrivateKeyPassword(@Nullable String password) {
        this.keyPass = StringSupport.trimOrNull((String)password);
    }

    public PrivateKey getObject() throws Exception {
        if (this.key == null) {
            if (this.resource == null) {
                throw new BeanCreationException("Private key resource must be provided in order to use this factory.");
            }
            try (InputStream is = this.resource.getInputStream();){
                this.key = this.keyPass == null ? KeyPairUtil.readPrivateKey((InputStream)is) : KeyPairUtil.readPrivateKey((InputStream)is, (char[])this.keyPass.toCharArray());
            }
        }
        return this.key;
    }

    @Nonnull
    public Class<?> getObjectType() {
        return PrivateKey.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

