/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.service;

import com.google.common.base.Function;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ServiceException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.springframework.context.ApplicationContext;

public class ClassBasedServiceStrategy<T>
implements Function<ApplicationContext, ServiceableComponent<T>> {
    @Nonnull
    private final Class<? extends ServiceableComponent> serviceClaz;

    public ClassBasedServiceStrategy() {
        this(ServiceableComponent.class);
    }

    public ClassBasedServiceStrategy(Class<? extends ServiceableComponent> serviceableClaz) {
        this.serviceClaz = (Class)Constraint.isNotNull(serviceableClaz, (String)"Serviceable Class cannot be null");
    }

    @Nullable
    public ServiceableComponent<T> apply(@Nullable ApplicationContext appContext) {
        Collection components = appContext.getBeansOfType(this.serviceClaz).values();
        if (components.size() == 0) {
            throw new ServiceException("Reload did not produce any bean of type " + this.serviceClaz.getName());
        }
        if (components.size() > 1) {
            throw new ServiceException("Reload produced " + components.size() + " ServiceableComponents");
        }
        return (ServiceableComponent)components.iterator().next();
    }
}

