/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.configured;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.stickycode.configured.Configuration;
import net.stickycode.configured.ConfigurationAttribute;
import net.stickycode.configured.InvokingAnnotatedMethodProcessor;
import net.stickycode.exception.Preconditions;
import net.stickycode.reflector.MethodProcessor;
import net.stickycode.reflector.Reflector;
import net.stickycode.stereotype.configured.PostConfigured;
import net.stickycode.stereotype.configured.PreConfigured;

public class ConfiguredConfiguration
implements Configuration {
    private final Object target;
    private final List<ConfigurationAttribute> attributes = new ArrayList<ConfigurationAttribute>();

    public ConfiguredConfiguration(Object instance) {
        this.target = Preconditions.notNull((Object)instance, (String)"The target object of configuration should not be null");
    }

    public Iterator<ConfigurationAttribute> iterator() {
        return Collections.unmodifiableList(this.attributes).iterator();
    }

    public void preConfigure() {
        new Reflector().forEachMethod(new MethodProcessor[]{new InvokingAnnotatedMethodProcessor(PreConfigured.class)}).process(this.target);
    }

    public void postConfigure() {
        new Reflector().forEachMethod(new MethodProcessor[]{new InvokingAnnotatedMethodProcessor(PostConfigured.class)}).process(this.target);
    }

    public void register(ConfigurationAttribute attribute) {
        this.attributes.add(attribute);
    }

    public String toString() {
        return String.format("%s with attributes %s", this.getName(), this.attributes);
    }

    private String getName() {
        return Introspector.decapitalize(this.target.getClass().getSimpleName());
    }
}

