/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.configured;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.stickycode.configured.AnnotatedMethodsMustNotHaveParametersException;
import net.stickycode.configured.FailedToInvokeAnnotatedMethodException;
import net.stickycode.configured.ReturnTypeMustBeVoidException;
import net.stickycode.reflector.MethodProcessor;

public class InvokingAnnotatedMethodProcessor
implements MethodProcessor {
    private final Class<? extends Annotation> annotationClass;

    public InvokingAnnotatedMethodProcessor(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void processMethod(Object target, Method method) {
        try {
            method.invoke(target, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new FailedToInvokeAnnotatedMethodException(e, this.annotationClass, target, method);
        }
    }

    public boolean canProcess(Method method) {
        if (!method.isAnnotationPresent(this.annotationClass)) {
            return false;
        }
        if (!Void.TYPE.equals(method.getReturnType())) {
            throw new ReturnTypeMustBeVoidException(this.annotationClass, method);
        }
        if (method.getParameterTypes().length > 0) {
            throw new AnnotatedMethodsMustNotHaveParametersException(this.annotationClass, method);
        }
        return true;
    }

    public void sort(List<Method> methods) {
    }
}

