/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.configured;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.stickycode.bootstrap.ComponentContainer;
import net.stickycode.coercion.Coercion;
import net.stickycode.coercion.CoercionFinder;
import net.stickycode.coercion.CoercionTarget;
import net.stickycode.configuration.ConfigurationKey;
import net.stickycode.configuration.ConfigurationValue;
import net.stickycode.configuration.ResolvedConfiguration;
import net.stickycode.configured.ConfigurationAttribute;
import net.stickycode.configured.MissingConfigurationException;
import net.stickycode.reflector.Fields;

public class ConfiguredField
implements ConfigurationAttribute {
    private final Object defaultValue;
    private final Object target;
    private final Field field;
    private final CoercionTarget coercionTarget;
    private ResolvedConfiguration resolution;
    private Object value;
    private Coercion<Object> coercion;
    private ConfigurationKey namespace;
    private List<ConfigurationValue> defaultConfigurations;

    public ConfiguredField(ConfigurationKey namespace, Object target, Field field, CoercionTarget coercionTarget, List<ConfigurationValue> defaultConfigurations) {
        this.target = Objects.requireNonNull(target, "The target bean for a configured field cannot be null");
        this.field = Objects.requireNonNull(field, "A configured field cannot be null");
        this.coercionTarget = Objects.requireNonNull(coercionTarget, "A configured field must have a coercion target");
        this.namespace = namespace;
        this.defaultConfigurations = defaultConfigurations;
        this.defaultValue = this.getValue();
    }

    public Object getValue() {
        return Fields.get((Object)this.target, (Field)this.field);
    }

    public String toString() {
        return this.join(".").get(0);
    }

    public CoercionTarget getCoercionTarget() {
        return this.coercionTarget;
    }

    public List<String> join(String delimeter) {
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : this.namespace.join(delimeter)) {
            keys.add(key + delimeter + this.field.getName());
        }
        return keys;
    }

    public void resolvedWith(ResolvedConfiguration resolved) {
        this.resolution = resolved;
    }

    public ResolvedConfiguration getResolution() {
        return this.resolution;
    }

    public void applyCoercion(CoercionFinder coercions) {
        this.coercion = coercions.find(this.coercionTarget);
        this.value = this.resolveValue();
    }

    private Object resolveValue() {
        if (this.resolution.hasValue()) {
            return this.coercion.coerce(this.coercionTarget, this.resolution.getValue());
        }
        if (this.coercion.hasDefaultValue()) {
            return this.coercion.getDefaultValue(this.coercionTarget);
        }
        return null;
    }

    public void update() {
        if (this.value != null) {
            Fields.set((Object)this.target, (Field)this.field, (Object)this.value);
        } else if (this.defaultValue == null) {
            throw new MissingConfigurationException((ConfigurationKey)this, this.resolution);
        }
    }

    public void invertControl(ComponentContainer container) {
        if (this.value == null) {
            return;
        }
        if (this.coercion.isInverted()) {
            return;
        }
        container.inject(this.value);
    }

    public Object getTarget() {
        return this.target;
    }

    public boolean requiresResolution() {
        return this.resolution == null;
    }

    public void apply(ResolvedConfiguration resolution) {
        for (ConfigurationValue configurationValue : this.defaultConfigurations) {
            resolution.add(configurationValue);
        }
    }
}

