/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.configured;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.stickycode.coercion.CoercionTarget;
import net.stickycode.coercion.target.CoercionTargets;
import net.stickycode.configuration.ConfigurationKey;
import net.stickycode.configuration.ConfigurationTarget;
import net.stickycode.configuration.ConfigurationValue;
import net.stickycode.configured.ConfigurationAttribute;
import net.stickycode.configured.ConfigurationRepository;
import net.stickycode.configured.ConfiguredField;
import net.stickycode.configured.ConfiguredFieldsMustNotBePrimitiveAsDefaultDerivationIsImpossibleException;
import net.stickycode.configured.ConfiguredMetadata;
import net.stickycode.reflector.AnnotatedFieldProcessor;

public class ConfiguredFieldProcessor
extends AnnotatedFieldProcessor {
    private final ConfigurationRepository configuration;
    private ConfigurationTarget parent;
    private Map<Class<? extends Annotation>, Method> defaultSeeds;

    public ConfiguredFieldProcessor(ConfigurationRepository configuration, ConfiguredMetadata annotations, ConfigurationTarget parent2) {
        super((Class[])annotations.getConfiguredAnnotations());
        this.configuration = configuration;
        this.defaultSeeds = annotations.getDefaultSeeds();
        this.parent = parent2;
    }

    public void processField(Object target, Field field) {
        if (field.getType().isPrimitive()) {
            throw new ConfiguredFieldsMustNotBePrimitiveAsDefaultDerivationIsImpossibleException(target, field);
        }
        this.configuration.register((ConfigurationAttribute)new ConfiguredField((ConfigurationKey)this.parent, target, field, this.fieldTarget(field), this.deriveDefaultConfiguration(field)));
    }

    private List<ConfigurationValue> deriveDefaultConfiguration(Field field) {
        if (this.defaultSeeds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ConfigurationValue> seeds = new ArrayList<ConfigurationValue>();
        for (Class<? extends Annotation> type : this.defaultSeeds.keySet()) {
            String seed = this.getDefaultKey(field, type);
            if (seed == null) continue;
            seeds.add(new DefaultConfigurationValue(seed));
        }
        return seeds;
    }

    private String getDefaultKey(Field field, Class<? extends Annotation> type) {
        Annotation a = field.getAnnotation(type);
        if (a != null) {
            try {
                return (String)this.defaultSeeds.get(type).invoke((Object)a, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return null;
            }
        }
        return null;
    }

    private CoercionTarget fieldTarget(Field field) {
        if (this.parent.getCoercionTarget() == null) {
            return CoercionTargets.find((Field)field);
        }
        return CoercionTargets.find((Field)field, (CoercionTarget)this.parent.getCoercionTarget());
    }

    private final class DefaultConfigurationValue
    implements ConfigurationValue {
        private String seed;

        public DefaultConfigurationValue(String seed) {
            this.seed = seed;
        }

        public boolean hasPrecedence(ConfigurationValue v) {
            return false;
        }

        public String get() {
            return this.seed;
        }

        public String toString() {
            return String.format("DefaultConfiguration[%s]", this.seed);
        }
    }
}

