/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.configured;

import java.util.Set;
import javax.inject.Inject;
import net.stickycode.bootstrap.AbstractStickySystem;
import net.stickycode.configured.ConfigurationListener;
import net.stickycode.stereotype.configured.Configured;
import net.stickycode.stereotype.plugin.StickyExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StickyExtension
public class ConfigurationSystem
extends AbstractStickySystem {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    private Set<ConfigurationListener> listeners;

    public void start() {
        this.log.info("configuration starting");
        this.log.debug("beforeconfiguration");
        for (ConfigurationListener listener : this.listeners) {
            listener.beforeConfiguration();
        }
        this.log.debug("resolving");
        for (ConfigurationListener listener : this.listeners) {
            listener.resolve();
        }
        this.log.debug("preconfiguring");
        for (ConfigurationListener listener : this.listeners) {
            listener.preConfigure();
        }
        this.log.debug("configuring");
        for (ConfigurationListener listener : this.listeners) {
            listener.configure();
        }
        this.log.debug("postconfiguring");
        for (ConfigurationListener listener : this.listeners) {
            listener.postConfigure();
        }
        this.log.debug("afterconfiguration");
        for (ConfigurationListener listener : this.listeners) {
            listener.afterConfiguration();
        }
        this.log.info("configuration complete");
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getLabel() {
        return Configured.class.getSimpleName();
    }

    public Package getPackage() {
        return ((Object)((Object)this)).getClass().getPackage();
    }
}

