/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.configured;

import java.util.ConcurrentModificationException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import net.stickycode.bootstrap.ComponentContainer;
import net.stickycode.coercion.CoercionFinder;
import net.stickycode.configuration.ConfigurationTarget;
import net.stickycode.configuration.ConfigurationTargetResolver;
import net.stickycode.configured.Configuration;
import net.stickycode.configured.ConfigurationAttribute;
import net.stickycode.configured.ConfigurationListener;
import net.stickycode.configured.ConfigurationRepository;
import net.stickycode.configured.TriedToInvertAnInvertedValue;
import net.stickycode.stereotype.StickyPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StickyPlugin
public class ConfiguredConfigurationListener
implements ConfigurationListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private ConfigurationTargetResolver resolver;
    @Inject
    private CoercionFinder coercions;
    @Inject
    private ConfigurationRepository configurations;
    @Inject
    private ComponentContainer container;

    @PostConstruct
    public void initialise() {
        this.log.info(" resolving values with {} and coercing with {}", (Object)this.resolver, (Object)this.coercions);
    }

    public void resolve() {
        this.log.debug("starting resolution - pass 1");
        for (Configuration configuration : this.configurations) {
            this.resolveAttributes(configuration);
        }
        this.log.debug("starting resolution - pass 2");
        for (Configuration configuration : this.configurations) {
            for (ConfigurationAttribute attribute : configuration) {
                if (!attribute.requiresResolution()) continue;
                this.log.debug("resolve second pass {}", (Object)attribute);
                this.resolver.resolve((ConfigurationTarget)attribute);
                attribute.applyCoercion(this.coercions);
                attribute.invertControl(this.container);
            }
        }
    }

    private void resolveAttributes(Configuration configuration) {
        this.log.debug("resolve {}", (Object)configuration);
        try {
            for (ConfigurationAttribute attribute : configuration) {
                this.resolveAttribute(attribute);
            }
        }
        catch (ConcurrentModificationException e) {
            throw new TriedToInvertAnInvertedValue(configuration);
        }
    }

    private void resolveAttribute(ConfigurationAttribute attribute) {
        if (attribute.requiresResolution()) {
            this.log.debug("resolve {}", (Object)attribute);
            this.resolver.resolve((ConfigurationTarget)attribute);
            attribute.applyCoercion(this.coercions);
        }
        attribute.invertControl(this.container);
    }

    public void preConfigure() {
        for (Configuration configuration : this.configurations) {
            configuration.preConfigure();
        }
    }

    public void configure() {
        this.log.debug("configurations {}", (Object)this.configurations);
        for (Configuration configuration : this.configurations) {
            this.configure(configuration);
        }
    }

    public void postConfigure() {
        for (Configuration configuration : this.configurations) {
            configuration.postConfigure();
        }
    }

    public void beforeConfiguration() {
        for (Configuration configuration : this.configurations) {
            configuration.beforeConfiguration();
        }
    }

    public void afterConfiguration() {
        for (Configuration configuration : this.configurations) {
            configuration.afterConfiguration();
        }
    }

    void configure(Configuration configuration) {
        for (ConfigurationAttribute attribute : configuration) {
            this.updateAttribute(attribute);
        }
    }

    void updateAttribute(ConfigurationAttribute field) {
        field.update();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

