/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.configured;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import net.stickycode.configured.Configuration;
import net.stickycode.configured.ConfigurationAttribute;
import net.stickycode.configured.ConfigurationRepository;
import net.stickycode.configured.ConfiguredConfiguration;
import net.stickycode.configured.ForMethodOnlyBeansDummyAttribute;
import net.stickycode.stereotype.StickyFramework;
import net.stickycode.stereotype.component.StickyRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StickyFramework
@StickyRepository
public class InlineConfigurationRepository
implements ConfigurationRepository {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<Object, ConfiguredConfiguration> configurations = new HashMap<Object, ConfiguredConfiguration>();
    private ReentrantLock lock = new ReentrantLock();

    public Iterator<Configuration> iterator() {
        return new LinkedList<ConfiguredConfiguration>(this.configurations.values()).iterator();
    }

    public void register(ConfigurationAttribute attribute) {
        assert (attribute != null);
        Configuration configuration = this.getConfiguration(attribute.getTarget());
        if (attribute instanceof ForMethodOnlyBeansDummyAttribute) {
            return;
        }
        this.log.info("registering {} for {} on {}", new Object[]{attribute, attribute.getTarget(), configuration});
        configuration.register(attribute);
    }

    private Configuration getConfiguration(Object target) {
        try {
            this.lock.lock();
            if (!this.configurations.containsKey(target)) {
                this.configurations.put(target, new ConfiguredConfiguration(target));
            }
            Configuration configuration = this.configurations.get(target);
            return configuration;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.configurations.values().toString();
    }
}

