/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.reflector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public abstract class AnnotationFinder {
    public static Class<? extends Annotation>[] load(String group, String type) {
        String name = "META-INF/" + group + "/" + type + ".annotations";
        ArrayList<Class<? extends Annotation>> annotations = new ArrayList<Class<? extends Annotation>>();
        Enumeration<URL> controlNames = AnnotationFinder.loadResources(name);
        for (URL url : Collections.list(controlNames)) {
            AnnotationFinder.loadUrl(annotations, url);
        }
        return annotations.toArray(new Class[annotations.size()]);
    }

    private static Enumeration<URL> loadResources(String name) {
        try {
            return AnnotationFinder.class.getClassLoader().getResources(name);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not find annotation manifest " + name, e);
        }
    }

    private static void loadUrl(List<Class<? extends Annotation>> annotations, URL url) {
        try {
            AnnotationFinder.loadUrlStream(annotations, url);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not find annotation manifest " + url, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadUrlStream(List<Class<? extends Annotation>> annotations, URL url) throws IOException {
        try (InputStream stream = url.openStream();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line = reader.readLine();
            while (line != null) {
                annotations.add(AnnotationFinder.loadClass(line));
                line = reader.readLine();
            }
        }
    }

    private static Class<? extends Annotation> loadClass(String line) {
        Class<?> klass = AnnotationFinder.unsafeLoadClass(line);
        if (!Annotation.class.isAssignableFrom(klass)) {
            throw new RuntimeException(line + " was supposed to be an annotation but its not!");
        }
        return klass;
    }

    private static Class<?> unsafeLoadClass(String line) {
        try {
            return AnnotationFinder.class.getClassLoader().loadClass(line);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cound not load class for annotation " + line, e);
        }
    }
}

