/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.reflector;

import java.lang.reflect.Field;
import net.stickycode.reflector.TriedToAccessFieldButWasDeniedException;

public class Fields {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(Object target, Field field, Object value) {
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            Fields.safeSetValue(target, field, value);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    private static void safeSetValue(Object target, Field field, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new TriedToAccessFieldButWasDeniedException(e, field, target);
        }
        catch (IllegalAccessException e) {
            throw new TriedToAccessFieldButWasDeniedException(e, field, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T get(Object bean, Field field) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            T t = Fields.safeGetField(bean, field);
            return t;
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    private static <T> T safeGetField(Object target, Field field) {
        try {
            return (T)field.get(target);
        }
        catch (IllegalArgumentException e) {
            throw new TriedToAccessFieldButWasDeniedException(e, field, target);
        }
        catch (IllegalAccessException e) {
            throw new TriedToAccessFieldButWasDeniedException(e, field, target);
        }
    }

    public static Field find(Class<?> type, String name) {
        try {
            return type.getDeclaredField(name);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

