/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.reflector;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.stickycode.reflector.TriedToAccessMethodButWasDeniedException;

public class Methods {
    public static <T> T invoke(Object target, Class<?> type, String method, Object ... values) {
        return Methods.invoke(target, Methods.find(type, method), values);
    }

    public static <T> T invoke(Object target, String method, Object ... values) {
        return Methods.invoke(target, Methods.find(target.getClass(), method), values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T invoke(Object target, Method method, Object[] values) {
        boolean accessible = method.isAccessible();
        method.setAccessible(true);
        try {
            T t = Methods.safeSetValue(target, method, values);
            return t;
        }
        finally {
            method.setAccessible(accessible);
        }
    }

    public static <T> T safeSetValue(Object target, Method method, Object[] values) {
        try {
            return (T)method.invoke(target, values);
        }
        catch (IllegalArgumentException e) {
            throw new TriedToAccessMethodButWasDeniedException(e, method, target);
        }
        catch (IllegalAccessException e) {
            throw new TriedToAccessMethodButWasDeniedException(e, method, target);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method find(Class<?> type, String name) {
        try {
            return type.getDeclaredMethod(name, new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

