/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.reflector.predicate;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.stickycode.reflector.predicate.FieldPredicate;
import net.stickycode.reflector.predicate.MethodPredicate;
import net.stickycode.reflector.predicate.TypePredicate;

public class PredicateReflector {
    private Class<?> type;

    public PredicateReflector given(Class<?> type) {
        this.type = type;
        return this;
    }

    public boolean isDirectly(TypePredicate condition) {
        return condition.apply(this.type);
    }

    public boolean hierachyIs(TypePredicate condition) {
        for (Class<?> current = this.type; current != null; current = current.getSuperclass()) {
            if (!condition.apply(current)) continue;
            return true;
        }
        return false;
    }

    public boolean contractIs(TypePredicate condition) {
        return this.contractIs(condition, this.type);
    }

    protected boolean contractIs(TypePredicate condition, Class<?> base) {
        for (Class<?> current = base; current != null; current = current.getSuperclass()) {
            if (condition.apply(current)) {
                return true;
            }
            for (Class<?> i : current.getInterfaces()) {
                if (!this.contractIs(condition, i)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean areAnyMethods(MethodPredicate condition) {
        for (Class<?> current = this.type; current != null; current = current.getSuperclass()) {
            for (Method m : current.getDeclaredMethods()) {
                if (!condition.apply(m)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean areAllMethods(MethodPredicate condition) {
        for (Class<?> current = this.type; current != null; current = current.getSuperclass()) {
            for (Method m : current.getDeclaredMethods()) {
                if (condition.apply(m)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean areAnyFields(FieldPredicate condition) {
        for (Class<?> current = this.type; current != null; current = current.getSuperclass()) {
            for (Field m : current.getDeclaredFields()) {
                if (!condition.apply(m)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean areAllFields(FieldPredicate condition) {
        for (Class<?> current = this.type; current != null; current = current.getSuperclass()) {
            for (Field m : current.getDeclaredFields()) {
                if (condition.apply(m)) continue;
                return false;
            }
        }
        return true;
    }
}

