/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.certvalidator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import network.oxalis.commons.certvalidator.api.CertificateValidationException;
import network.oxalis.commons.certvalidator.api.Property;
import network.oxalis.commons.certvalidator.api.Report;
import network.oxalis.commons.certvalidator.api.ValidatorRule;
import network.oxalis.commons.certvalidator.util.DummyReport;
import network.oxalis.commons.certvalidator.util.SimpleProperty;

public class Validator
implements ValidatorRule {
    public static final Property<X509Certificate> CERTIFICATE = SimpleProperty.create();
    private static CertificateFactory certFactory;
    private ValidatorRule validatorRule;

    public static X509Certificate getCertificate(byte[] cert) throws CertificateValidationException {
        return Validator.getCertificate(new ByteArrayInputStream(cert));
    }

    public static X509Certificate getCertificate(InputStream inputStream) throws CertificateValidationException {
        try {
            if (certFactory == null) {
                certFactory = CertificateFactory.getInstance("X.509");
            }
            return (X509Certificate)certFactory.generateCertificate(inputStream);
        }
        catch (CertificateException e) {
            throw new CertificateValidationException(e.getMessage(), e);
        }
    }

    public Validator(ValidatorRule validatorRule) {
        this.validatorRule = validatorRule;
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        this.validate(certificate, (Report)DummyReport.INSTANCE);
    }

    @Override
    public Report validate(X509Certificate certificate, Report report) throws CertificateValidationException {
        return this.validatorRule.validate(certificate, report);
    }

    public X509Certificate validate(InputStream inputStream) throws CertificateValidationException {
        X509Certificate certificate = Validator.getCertificate(inputStream);
        this.validate(certificate);
        return certificate;
    }

    public Report validate(InputStream inputStream, Report report) throws CertificateValidationException {
        X509Certificate certificate = Validator.getCertificate(inputStream);
        this.validate(certificate, report);
        report.set(CERTIFICATE, certificate);
        return report;
    }

    public X509Certificate validate(byte[] bytes) throws CertificateValidationException {
        X509Certificate certificate = Validator.getCertificate(bytes);
        this.validate(certificate);
        return certificate;
    }

    public Report validate(byte[] bytes, Report report) throws CertificateValidationException {
        X509Certificate certificate = Validator.getCertificate(bytes);
        this.validate(certificate, report);
        report.set(CERTIFICATE, certificate);
        return report;
    }

    public boolean isValid(X509Certificate certificate) {
        try {
            this.validate(certificate, (Report)DummyReport.INSTANCE);
            return true;
        }
        catch (CertificateValidationException e) {
            return false;
        }
    }

    public boolean isValid(InputStream inputStream) {
        try {
            return this.isValid(Validator.getCertificate(inputStream));
        }
        catch (CertificateValidationException e) {
            return false;
        }
    }

    public boolean isValid(byte[] bytes) {
        try {
            return this.isValid(Validator.getCertificate(bytes));
        }
        catch (CertificateValidationException e) {
            return false;
        }
    }
}

