/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.certvalidator.rule;

import java.security.GeneralSecurityException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import network.oxalis.commons.certvalidator.api.CertificateBucket;
import network.oxalis.commons.certvalidator.api.CertificateValidationException;
import network.oxalis.commons.certvalidator.api.FailedValidationException;
import network.oxalis.commons.certvalidator.api.Property;
import network.oxalis.commons.certvalidator.api.Report;
import network.oxalis.commons.certvalidator.rule.AbstractRule;
import network.oxalis.commons.certvalidator.util.BCHelper;
import network.oxalis.commons.certvalidator.util.SimpleProperty;

public class ChainRule
extends AbstractRule {
    public static final Property<List<? extends Certificate>> PATH = SimpleProperty.create();
    public static final Property<X509Certificate> ANCHOR = SimpleProperty.create();
    private CertificateBucket rootCertificates;
    private CertificateBucket intermediateCertificates;
    private Set<String> policies = new HashSet<String>();

    public ChainRule(CertificateBucket rootCertificates, CertificateBucket intermediateCertificates, String ... policies) {
        this.rootCertificates = rootCertificates;
        this.intermediateCertificates = intermediateCertificates;
        this.policies.addAll(Arrays.asList(policies));
    }

    @Override
    public Report validate(X509Certificate certificate, Report report) throws CertificateValidationException {
        try {
            PKIXCertPathBuilderResult result = this.verifyCertificate(certificate);
            report.set(ANCHOR, result.getTrustAnchor().getTrustedCert());
            report.set(PATH, result.getCertPath().getCertificates());
            return report;
        }
        catch (GeneralSecurityException e) {
            throw new FailedValidationException(e.getMessage(), e);
        }
    }

    private PKIXCertPathBuilderResult verifyCertificate(X509Certificate cert) throws GeneralSecurityException {
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(cert);
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate trustedRootCert : this.rootCertificates) {
            trustAnchors.add(new TrustAnchor(trustedRootCert, null));
        }
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
        if (!this.policies.isEmpty()) {
            pkixParams.setInitialPolicies(this.policies);
            pkixParams.setExplicitPolicyRequired(true);
        }
        pkixParams.setRevocationEnabled(false);
        HashSet<X509Certificate> trustedIntermediateCert = new HashSet<X509Certificate>();
        for (X509Certificate certificate : this.intermediateCertificates) {
            trustedIntermediateCert.add(certificate);
        }
        trustedIntermediateCert.add(cert);
        pkixParams.addCertStore(CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(trustedIntermediateCert), BCHelper.PROVIDER));
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", BCHelper.PROVIDER);
        return (PKIXCertPathBuilderResult)builder.build(pkixParams);
    }
}

