/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.certvalidator.rule;

import java.security.cert.X509Certificate;
import network.oxalis.commons.certvalidator.api.CertificateValidationException;
import network.oxalis.commons.certvalidator.api.FailedValidationException;
import network.oxalis.commons.certvalidator.rule.AbstractRule;

public class ExpirationSoonRule
extends AbstractRule {
    private long millis;

    public ExpirationSoonRule(long millis) {
        this.millis = millis;
    }

    @Override
    public void validate(X509Certificate certificate) throws CertificateValidationException {
        if (certificate.getNotAfter().getTime() < System.currentTimeMillis() + this.millis) {
            throw new FailedValidationException(String.format("Certificate expires in less than %s milliseconds.", this.millis));
        }
    }
}

