/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.DirectExecutionContext;
import org.apache.beam.runners.direct.DoFnLifecycleManager;
import org.apache.beam.runners.direct.DoFnLifecycleManagerRemovingTransformEvaluator;
import org.apache.beam.runners.direct.DoFnLifecycleManagers;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.ParDoEvaluator;
import org.apache.beam.runners.direct.StructuralKey;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.repackaged.com.google.common.cache.CacheBuilder;
import org.apache.beam.runners.direct.repackaged.com.google.common.cache.CacheLoader;
import org.apache.beam.runners.direct.repackaged.com.google.common.cache.LoadingCache;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ParDoEvaluatorFactory<InputT, OutputT>
implements TransformEvaluatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ParDoEvaluatorFactory.class);
    private final LoadingCache<DoFn<?, ?>, DoFnLifecycleManager> fnClones;
    private final EvaluationContext evaluationContext;
    private final ParDoEvaluator.DoFnRunnerFactory<InputT, OutputT> runnerFactory;

    ParDoEvaluatorFactory(EvaluationContext evaluationContext, ParDoEvaluator.DoFnRunnerFactory<InputT, OutputT> runnerFactory) {
        this.evaluationContext = evaluationContext;
        this.runnerFactory = runnerFactory;
        this.fnClones = CacheBuilder.newBuilder().build(new CacheLoader<DoFn<?, ?>, DoFnLifecycleManager>(){

            @Override
            public DoFnLifecycleManager load(DoFn<?, ?> key) throws Exception {
                return DoFnLifecycleManager.of(key);
            }
        });
    }

    public <T> TransformEvaluator<T> forApplication(AppliedPTransform<?, ?, ?> application, CommittedBundle<?> inputBundle) throws Exception {
        AppliedPTransform<?, ?, ?> parDoApplication = application;
        ParDo.MultiOutput transform = (ParDo.MultiOutput)parDoApplication.getTransform();
        DoFn doFn = transform.getFn();
        DoFnLifecycleManagerRemovingTransformEvaluator<InputT> evaluator = this.createEvaluator(application, inputBundle.getKey(), doFn, transform.getSideInputs(), transform.getMainOutputTag(), transform.getAdditionalOutputTags().getAll());
        return evaluator;
    }

    @Override
    public void cleanup() throws Exception {
        DoFnLifecycleManagers.removeAllFromManagers(this.fnClones.asMap().values());
    }

    DoFnLifecycleManagerRemovingTransformEvaluator<InputT> createEvaluator(AppliedPTransform<PCollection<InputT>, PCollectionTuple, ?> application, StructuralKey<?> inputBundleKey, DoFn<InputT, OutputT> doFn, List<PCollectionView<?>> sideInputs, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> additionalOutputTags) throws Exception {
        String stepName = this.evaluationContext.getStepName(application);
        DirectExecutionContext.DirectStepContext stepContext = (DirectExecutionContext.DirectStepContext)this.evaluationContext.getExecutionContext(application, inputBundleKey).getOrCreateStepContext(stepName, stepName);
        DoFnLifecycleManager fnManager = this.fnClones.getUnchecked(doFn);
        return DoFnLifecycleManagerRemovingTransformEvaluator.wrapping(this.createParDoEvaluator(application, inputBundleKey, sideInputs, mainOutputTag, additionalOutputTags, stepContext, fnManager.get(), fnManager), fnManager);
    }

    ParDoEvaluator<InputT> createParDoEvaluator(AppliedPTransform<PCollection<InputT>, PCollectionTuple, ?> application, StructuralKey<?> key, List<PCollectionView<?>> sideInputs, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> additionalOutputTags, DirectExecutionContext.DirectStepContext stepContext, DoFn<InputT, OutputT> fn, DoFnLifecycleManager fnManager) throws Exception {
        try {
            return ParDoEvaluator.create(this.evaluationContext, stepContext, application, ((PCollection)Iterables.getOnlyElement(application.getInputs().values())).getWindowingStrategy(), fn, key, sideInputs, mainOutputTag, additionalOutputTags, ParDoEvaluatorFactory.pcollections(application.getOutputs()), this.runnerFactory);
        }
        catch (Exception e) {
            try {
                fnManager.remove();
            }
            catch (Exception removalException) {
                LOG.error("Exception encountered while cleaning up in ParDo evaluator construction", (Throwable)removalException);
                e.addSuppressed(removalException);
            }
            throw e;
        }
    }

    static Map<TupleTag<?>, PCollection<?>> pcollections(Map<TupleTag<?>, PValue> outputs) {
        HashMap pcs = new HashMap();
        for (Map.Entry<TupleTag<?>, PValue> output : outputs.entrySet()) {
            pcs.put(output.getKey(), (PCollection)output.getValue());
        }
        return pcs;
    }
}

