/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.runners.direct.BoundedReadEvaluatorFactory;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.DirectGroupByKey;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.FlattenEvaluatorFactory;
import org.apache.beam.runners.direct.GroupAlsoByWindowEvaluatorFactory;
import org.apache.beam.runners.direct.GroupByKeyOnlyEvaluatorFactory;
import org.apache.beam.runners.direct.ParDoEvaluator;
import org.apache.beam.runners.direct.ParDoEvaluatorFactory;
import org.apache.beam.runners.direct.ParDoMultiOverrideFactory;
import org.apache.beam.runners.direct.SplittableProcessElementsEvaluatorFactory;
import org.apache.beam.runners.direct.StatefulParDoEvaluatorFactory;
import org.apache.beam.runners.direct.TestStreamEvaluatorFactory;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.UnboundedReadEvaluatorFactory;
import org.apache.beam.runners.direct.ViewEvaluatorFactory;
import org.apache.beam.runners.direct.ViewOverrideFactory;
import org.apache.beam.runners.direct.WindowEvaluatorFactory;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.runners.direct.repackaged.runners.core.SplittableParDo;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransformEvaluatorRegistry
implements TransformEvaluatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TransformEvaluatorRegistry.class);
    private final Map<Class<? extends PTransform>, TransformEvaluatorFactory> factories;
    private final AtomicBoolean finished = new AtomicBoolean(false);

    public static TransformEvaluatorRegistry defaultRegistry(EvaluationContext ctxt) {
        ImmutableMap<Class<? extends PTransform>, TransformEvaluatorFactory> primitives = ImmutableMap.builder().put(Read.Bounded.class, new BoundedReadEvaluatorFactory(ctxt)).put(Read.Unbounded.class, (BoundedReadEvaluatorFactory)((Object)new UnboundedReadEvaluatorFactory(ctxt))).put((Class<Read.Unbounded>)ParDo.MultiOutput.class, (BoundedReadEvaluatorFactory)((Object)new ParDoEvaluatorFactory(ctxt, ParDoEvaluator.defaultRunnerFactory()))).put((Class<ParDo.MultiOutput>)ParDoMultiOverrideFactory.StatefulParDo.class, new StatefulParDoEvaluatorFactory(ctxt)).put((Class<ParDoMultiOverrideFactory.StatefulParDo>)Flatten.PCollections.class, new FlattenEvaluatorFactory(ctxt)).put(ViewOverrideFactory.WriteView.class, (FlattenEvaluatorFactory)((Object)new ViewEvaluatorFactory(ctxt))).put(Window.Assign.class, (FlattenEvaluatorFactory)((Object)new WindowEvaluatorFactory(ctxt))).put(DirectGroupByKey.DirectGroupByKeyOnly.class, (FlattenEvaluatorFactory)((Object)new GroupByKeyOnlyEvaluatorFactory(ctxt))).put(DirectGroupByKey.DirectGroupAlsoByWindow.class, (FlattenEvaluatorFactory)((Object)new GroupAlsoByWindowEvaluatorFactory(ctxt))).put(TestStreamEvaluatorFactory.DirectTestStreamFactory.DirectTestStream.class, (FlattenEvaluatorFactory)((Object)new TestStreamEvaluatorFactory(ctxt))).put((Class<TestStreamEvaluatorFactory.DirectTestStreamFactory.DirectTestStream>)SplittableParDo.ProcessElements.class, (FlattenEvaluatorFactory)((Object)new SplittableProcessElementsEvaluatorFactory(ctxt))).build();
        return new TransformEvaluatorRegistry(primitives);
    }

    private TransformEvaluatorRegistry(Map<Class<? extends PTransform>, TransformEvaluatorFactory> factories) {
        this.factories = factories;
    }

    @Override
    public <InputT> TransformEvaluator<InputT> forApplication(AppliedPTransform<?, ?, ?> application, CommittedBundle<?> inputBundle) throws Exception {
        Preconditions.checkState(!this.finished.get(), "Tried to get an evaluator for a finished TransformEvaluatorRegistry");
        Class<?> transformClass = application.getTransform().getClass();
        TransformEvaluatorFactory factory = Preconditions.checkNotNull(this.factories.get(transformClass), "No evaluator for PTransform type %s", transformClass);
        return factory.forApplication(application, inputBundle);
    }

    @Override
    public void cleanup() throws Exception {
        ArrayList<Exception> thrownInCleanup = new ArrayList<Exception>();
        for (TransformEvaluatorFactory factory : this.factories.values()) {
            try {
                factory.cleanup();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                thrownInCleanup.add(e);
            }
        }
        this.finished.set(true);
        if (!thrownInCleanup.isEmpty()) {
            LOG.error("Exceptions {} thrown while cleaning up evaluators", thrownInCleanup);
            Exception toThrow = null;
            for (Exception e : thrownInCleanup) {
                if (toThrow == null) {
                    toThrow = e;
                    continue;
                }
                toThrow.addSuppressed(e);
            }
            throw toThrow;
        }
    }
}

