/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.runners.direct.repackaged.javax.annotation.Nullable;
import org.apache.beam.runners.direct.repackaged.runners.core.StateInternals;
import org.apache.beam.runners.direct.repackaged.runners.core.StateNamespace;
import org.apache.beam.runners.direct.repackaged.runners.core.StateTable;
import org.apache.beam.runners.direct.repackaged.runners.core.StateTag;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.MapState;
import org.apache.beam.sdk.state.ReadableState;
import org.apache.beam.sdk.state.ReadableStates;
import org.apache.beam.sdk.state.SetState;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.sdk.state.StateContexts;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.state.WatermarkHoldState;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.util.CombineFnUtil;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.STATE)
public class InMemoryStateInternals<K>
implements StateInternals {
    private final K key;
    protected final StateTable inMemoryState = new StateTable(){

        @Override
        protected StateTag.StateBinder binderForNamespace(StateNamespace namespace, StateContext<?> c) {
            return new InMemoryStateBinder(c);
        }
    };

    public static <K> InMemoryStateInternals<K> forKey(K key) {
        return new InMemoryStateInternals<K>(key);
    }

    protected InMemoryStateInternals(K key) {
        this.key = key;
    }

    public K getKey() {
        return this.key;
    }

    public void clear() {
        this.inMemoryState.clear();
    }

    protected boolean isEmptyForTesting(State state) {
        return ((InMemoryState)state).isCleared();
    }

    @Override
    public <T extends State> T state(StateNamespace namespace, StateTag<T> address) {
        return this.inMemoryState.get(namespace, address, StateContexts.nullContext());
    }

    @Override
    public <T extends State> T state(StateNamespace namespace, StateTag<T> address, StateContext<?> c) {
        return this.inMemoryState.get(namespace, address, c);
    }

    public static final class InMemoryMap<K, V>
    implements MapState<K, V>,
    InMemoryState<InMemoryMap<K, V>> {
        private Map<K, V> contents = new HashMap();

        public void clear() {
            this.contents = new HashMap();
        }

        public ReadableState<V> get(K key) {
            return ReadableStates.immediate(this.contents.get(key));
        }

        public void put(K key, V value) {
            this.contents.put(key, value);
        }

        public ReadableState<V> putIfAbsent(K key, V value) {
            V v = this.contents.get(key);
            if (v == null) {
                v = this.contents.put(key, value);
            }
            return ReadableStates.immediate(v);
        }

        public void remove(K key) {
            this.contents.remove(key);
        }

        public ReadableState<Iterable<K>> keys() {
            return ReadableStates.immediate(this.contents.keySet());
        }

        public ReadableState<Iterable<V>> values() {
            return ReadableStates.immediate(this.contents.values());
        }

        public ReadableState<Iterable<Map.Entry<K, V>>> entries() {
            return ReadableStates.immediate(this.contents.entrySet());
        }

        @Override
        public boolean isCleared() {
            return this.contents.isEmpty();
        }

        @Override
        public InMemoryMap<K, V> copy() {
            InMemoryMap<K, V> that = new InMemoryMap<K, V>();
            that.contents.putAll(this.contents);
            return that;
        }
    }

    public static final class InMemorySet<T>
    implements SetState<T>,
    InMemoryState<InMemorySet<T>> {
        private Set<T> contents = new HashSet<T>();

        public void clear() {
            this.contents = new HashSet<T>();
        }

        public ReadableState<Boolean> contains(T t) {
            return ReadableStates.immediate((Object)this.contents.contains(t));
        }

        public ReadableState<Boolean> addIfAbsent(T t) {
            boolean alreadyContained = this.contents.contains(t);
            this.contents.add(t);
            return ReadableStates.immediate((Object)(!alreadyContained ? 1 : 0));
        }

        public void remove(T t) {
            this.contents.remove(t);
        }

        public InMemorySet<T> readLater() {
            return this;
        }

        public Iterable<T> read() {
            return this.contents;
        }

        public void add(T input) {
            this.contents.add(input);
        }

        @Override
        public boolean isCleared() {
            return this.contents.isEmpty();
        }

        public ReadableState<Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                public ReadableState<Boolean> readLater() {
                    return this;
                }

                public Boolean read() {
                    return InMemorySet.this.contents.isEmpty();
                }
            };
        }

        @Override
        public InMemorySet<T> copy() {
            InMemorySet<T> that = new InMemorySet<T>();
            that.contents.addAll(this.contents);
            return that;
        }
    }

    public static final class InMemoryBag<T>
    implements BagState<T>,
    InMemoryState<InMemoryBag<T>> {
        private List<T> contents = new ArrayList<T>();

        public void clear() {
            this.contents = new ArrayList<T>();
        }

        public InMemoryBag<T> readLater() {
            return this;
        }

        public Iterable<T> read() {
            return this.contents;
        }

        public void add(T input) {
            this.contents.add(input);
        }

        @Override
        public boolean isCleared() {
            return this.contents.isEmpty();
        }

        public ReadableState<Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                public ReadableState<Boolean> readLater() {
                    return this;
                }

                public Boolean read() {
                    return InMemoryBag.this.contents.isEmpty();
                }
            };
        }

        @Override
        public InMemoryBag<T> copy() {
            InMemoryBag<T> that = new InMemoryBag<T>();
            that.contents.addAll(this.contents);
            return that;
        }
    }

    public static final class InMemoryCombiningState<InputT, AccumT, OutputT>
    implements CombiningState<InputT, AccumT, OutputT>,
    InMemoryState<InMemoryCombiningState<InputT, AccumT, OutputT>> {
        private boolean isCleared = true;
        private final Combine.CombineFn<InputT, AccumT, OutputT> combineFn;
        private AccumT accum;

        public InMemoryCombiningState(Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            this.combineFn = combineFn;
            this.accum = combineFn.createAccumulator();
        }

        public InMemoryCombiningState<InputT, AccumT, OutputT> readLater() {
            return this;
        }

        public void clear() {
            this.accum = this.combineFn.createAccumulator();
            this.isCleared = true;
        }

        public OutputT read() {
            return (OutputT)this.combineFn.extractOutput(this.accum);
        }

        public void add(InputT input) {
            this.isCleared = false;
            this.accum = this.combineFn.addInput(this.accum, input);
        }

        public AccumT getAccum() {
            return this.accum;
        }

        public ReadableState<Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                public ReadableState<Boolean> readLater() {
                    return this;
                }

                public Boolean read() {
                    return InMemoryCombiningState.this.isCleared;
                }
            };
        }

        public void addAccum(AccumT accum) {
            this.isCleared = false;
            this.accum = this.combineFn.mergeAccumulators(Arrays.asList(this.accum, accum));
        }

        public AccumT mergeAccumulators(Iterable<AccumT> accumulators) {
            return (AccumT)this.combineFn.mergeAccumulators(accumulators);
        }

        @Override
        public boolean isCleared() {
            return this.isCleared;
        }

        @Override
        public InMemoryCombiningState<InputT, AccumT, OutputT> copy() {
            InMemoryCombiningState<InputT, AccumT, OutputT> that = new InMemoryCombiningState<InputT, AccumT, OutputT>(this.combineFn);
            if (!this.isCleared) {
                that.isCleared = this.isCleared;
                that.addAccum(this.accum);
            }
            return that;
        }
    }

    public static final class InMemoryWatermarkHold<W extends BoundedWindow>
    implements WatermarkHoldState,
    InMemoryState<InMemoryWatermarkHold<W>> {
        private final TimestampCombiner timestampCombiner;
        @Nullable
        private Instant combinedHold = null;

        public InMemoryWatermarkHold(TimestampCombiner timestampCombiner) {
            this.timestampCombiner = timestampCombiner;
        }

        public InMemoryWatermarkHold readLater() {
            return this;
        }

        public void clear() {
            this.combinedHold = null;
        }

        public Instant read() {
            return this.combinedHold;
        }

        public void add(Instant outputTime) {
            this.combinedHold = this.combinedHold == null ? outputTime : this.timestampCombiner.combine(new Instant[]{this.combinedHold, outputTime});
        }

        @Override
        public boolean isCleared() {
            return this.combinedHold == null;
        }

        public ReadableState<Boolean> isEmpty() {
            return new ReadableState<Boolean>(){

                public ReadableState<Boolean> readLater() {
                    return this;
                }

                public Boolean read() {
                    return InMemoryWatermarkHold.this.combinedHold == null;
                }
            };
        }

        public TimestampCombiner getTimestampCombiner() {
            return this.timestampCombiner;
        }

        public String toString() {
            return Objects.toString(this.combinedHold);
        }

        @Override
        public InMemoryWatermarkHold<W> copy() {
            InMemoryWatermarkHold<W> that = new InMemoryWatermarkHold<W>(this.timestampCombiner);
            that.combinedHold = this.combinedHold;
            return that;
        }
    }

    public static final class InMemoryValue<T>
    implements ValueState<T>,
    InMemoryState<InMemoryValue<T>> {
        private boolean isCleared = true;
        private T value = null;

        public void clear() {
            this.value = null;
            this.isCleared = true;
        }

        public InMemoryValue<T> readLater() {
            return this;
        }

        public T read() {
            return this.value;
        }

        public void write(T input) {
            this.isCleared = false;
            this.value = input;
        }

        @Override
        public InMemoryValue<T> copy() {
            InMemoryValue<T> that = new InMemoryValue<T>();
            if (!this.isCleared) {
                that.isCleared = this.isCleared;
                that.value = this.value;
            }
            return that;
        }

        @Override
        public boolean isCleared() {
            return this.isCleared;
        }
    }

    public static class InMemoryStateBinder
    implements StateTag.StateBinder {
        private final StateContext<?> c;

        public InMemoryStateBinder(StateContext<?> c) {
            this.c = c;
        }

        @Override
        public <T> ValueState<T> bindValue(StateTag<ValueState<T>> address, Coder<T> coder) {
            return new InMemoryValue();
        }

        @Override
        public <T> BagState<T> bindBag(StateTag<BagState<T>> address, Coder<T> elemCoder) {
            return new InMemoryBag();
        }

        @Override
        public <T> SetState<T> bindSet(StateTag<SetState<T>> spec, Coder<T> elemCoder) {
            return new InMemorySet();
        }

        @Override
        public <KeyT, ValueT> MapState<KeyT, ValueT> bindMap(StateTag<MapState<KeyT, ValueT>> spec, Coder<KeyT> mapKeyCoder, Coder<ValueT> mapValueCoder) {
            return new InMemoryMap();
        }

        @Override
        public <InputT, AccumT, OutputT> CombiningState<InputT, AccumT, OutputT> bindCombiningValue(StateTag<CombiningState<InputT, AccumT, OutputT>> address, Coder<AccumT> accumCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            return new InMemoryCombiningState<InputT, AccumT, OutputT>(combineFn);
        }

        @Override
        public WatermarkHoldState bindWatermark(StateTag<WatermarkHoldState> address, TimestampCombiner timestampCombiner) {
            return new InMemoryWatermarkHold(timestampCombiner);
        }

        @Override
        public <InputT, AccumT, OutputT> CombiningState<InputT, AccumT, OutputT> bindCombiningValueWithContext(StateTag<CombiningState<InputT, AccumT, OutputT>> address, Coder<AccumT> accumCoder, CombineWithContext.CombineFnWithContext<InputT, AccumT, OutputT> combineFn) {
            return this.bindCombiningValue(address, accumCoder, CombineFnUtil.bindContext(combineFn, this.c));
        }
    }

    public static interface InMemoryState<T extends InMemoryState<T>> {
        public boolean isCleared();

        public T copy();
    }
}

