/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.beam.runners.direct.repackaged.runners.core.DoFnRunner;
import org.apache.beam.runners.direct.repackaged.runners.core.DoFnRunners;
import org.apache.beam.runners.direct.repackaged.runners.core.ExecutionContext;
import org.apache.beam.runners.direct.repackaged.runners.core.OldDoFn;
import org.apache.beam.runners.direct.repackaged.runners.core.SideInputReader;
import org.apache.beam.runners.direct.repackaged.runners.core.StateInternals;
import org.apache.beam.runners.direct.repackaged.runners.core.TimerInternals;
import org.apache.beam.runners.direct.repackaged.runners.core.WindowingInternals;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.Sets;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.SystemDoFnInternal;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;

class SimpleOldDoFnRunner<InputT, OutputT>
implements DoFnRunner<InputT, OutputT> {
    private final OldDoFn<InputT, OutputT> fn;
    private final DoFnContext<InputT, OutputT> context;

    public SimpleOldDoFnRunner(PipelineOptions options, OldDoFn<InputT, OutputT> fn, SideInputReader sideInputReader, DoFnRunners.OutputManager outputManager, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> additionalOutputTags, ExecutionContext.StepContext stepContext, WindowingStrategy<?, ?> windowingStrategy) {
        this.fn = fn;
        this.context = new DoFnContext<InputT, OutputT>(options, fn, sideInputReader, outputManager, mainOutputTag, additionalOutputTags, stepContext, windowingStrategy == null ? null : windowingStrategy.getWindowFn());
    }

    @Override
    public void startBundle() {
        try {
            this.fn.startBundle(this.context);
        }
        catch (Throwable t) {
            throw this.wrapUserCodeException(t);
        }
    }

    @Override
    public void processElement(WindowedValue<InputT> elem) {
        if (elem.getWindows().size() <= 1 || !OldDoFn.RequiresWindowAccess.class.isAssignableFrom(this.fn.getClass()) && this.context.sideInputReader.isEmpty()) {
            this.invokeProcessElement(elem);
        } else {
            for (WindowedValue windowedValue : elem.explodeWindows()) {
                this.invokeProcessElement(windowedValue);
            }
        }
    }

    @Override
    public void onTimer(String timerId, BoundedWindow window, Instant timestamp, TimeDomain timeDomain) {
        throw new UnsupportedOperationException(String.format("Timers are not supported by %s", OldDoFn.class.getSimpleName()));
    }

    private void invokeProcessElement(WindowedValue<InputT> elem) {
        OldDoFn.ProcessContext processContext = this.createProcessContext(elem);
        try {
            this.fn.processElement(processContext);
        }
        catch (Exception ex) {
            throw this.wrapUserCodeException(ex);
        }
    }

    @Override
    public void finishBundle() {
        try {
            this.fn.finishBundle(this.context);
        }
        catch (Throwable t) {
            throw this.wrapUserCodeException(t);
        }
    }

    private OldDoFn.ProcessContext createProcessContext(WindowedValue<InputT> elem) {
        return new DoFnProcessContext<InputT, OutputT>(this.fn, this.context, elem);
    }

    private RuntimeException wrapUserCodeException(Throwable t) {
        throw UserCodeException.wrapIf((!this.isSystemDoFn() ? 1 : 0) != 0, (Throwable)t);
    }

    private boolean isSystemDoFn() {
        return this.fn.getClass().isAnnotationPresent(SystemDoFnInternal.class);
    }

    private static class DoFnProcessContext<InputT, OutputT>
    extends OldDoFn.ProcessContext {
        final OldDoFn<InputT, OutputT> fn;
        final DoFnContext<InputT, OutputT> context;
        final WindowedValue<InputT> windowedValue;

        public DoFnProcessContext(OldDoFn<InputT, OutputT> fn, DoFnContext<InputT, OutputT> context, WindowedValue<InputT> windowedValue) {
            super(fn);
            this.fn = fn;
            this.context = context;
            this.windowedValue = windowedValue;
        }

        @Override
        public PipelineOptions getPipelineOptions() {
            return this.context.getPipelineOptions();
        }

        @Override
        public InputT element() {
            return (InputT)this.windowedValue.getValue();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public <T> T sideInput(PCollectionView<T> view) {
            BoundedWindow window;
            Preconditions.checkNotNull(view, "View passed to sideInput cannot be null");
            Iterator<BoundedWindow> windowIter = this.windows().iterator();
            if (!windowIter.hasNext()) {
                if (!(this.context.windowFn instanceof GlobalWindows)) throw new IllegalStateException("sideInput called when main input element is not in any windows");
                window = GlobalWindow.INSTANCE;
                return this.context.sideInput(view, view.getWindowMappingFn().getSideInputWindow(window));
            } else {
                window = windowIter.next();
                if (!windowIter.hasNext()) return this.context.sideInput(view, view.getWindowMappingFn().getSideInputWindow(window));
                throw new IllegalStateException("sideInput called when main input element is in multiple windows");
            }
        }

        @Override
        public BoundedWindow window() {
            if (!(this.fn instanceof OldDoFn.RequiresWindowAccess)) {
                throw new UnsupportedOperationException("window() is only available in the context of a OldDoFn marked asRequiresWindowAccess.");
            }
            return Iterables.getOnlyElement(this.windows());
        }

        @Override
        public PaneInfo pane() {
            return this.windowedValue.getPane();
        }

        @Override
        public void output(OutputT output) {
            this.context.outputWindowedValue(this.windowedValue.withValue(output));
        }

        @Override
        public void outputWithTimestamp(OutputT output, Instant timestamp) {
            this.checkTimestamp(timestamp);
            this.context.outputWindowedValue(output, timestamp, this.windowedValue.getWindows(), this.windowedValue.getPane());
        }

        void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
            this.context.outputWindowedValue(output, timestamp, windows, pane);
        }

        @Override
        public <T> void output(TupleTag<T> tag, T output) {
            Preconditions.checkNotNull(tag, "Tag passed to output cannot be null");
            ((DoFnContext)this.context).outputWindowedValue(tag, this.windowedValue.withValue(output));
        }

        @Override
        public <T> void outputWithTimestamp(TupleTag<T> tag, T output, Instant timestamp) {
            Preconditions.checkNotNull(tag, "Tag passed to outputWithTimestamp cannot be null");
            this.checkTimestamp(timestamp);
            ((DoFnContext)this.context).outputWindowedValue(tag, output, timestamp, this.windowedValue.getWindows(), this.windowedValue.getPane());
        }

        @Override
        public Instant timestamp() {
            return this.windowedValue.getTimestamp();
        }

        public Collection<? extends BoundedWindow> windows() {
            return this.windowedValue.getWindows();
        }

        private void checkTimestamp(Instant timestamp) {
            if (timestamp.isBefore((ReadableInstant)this.windowedValue.getTimestamp().minus((ReadableDuration)this.fn.getAllowedTimestampSkew()))) {
                throw new IllegalArgumentException(String.format("Cannot output with timestamp %s. Output timestamps must be no earlier than the timestamp of the current input (%s) minus the allowed skew (%s). See the OldDoFn#getAllowedTimestampSkew() Javadoc for details on changing the allowed skew.", timestamp, this.windowedValue.getTimestamp(), PeriodFormat.getDefault().print((ReadablePeriod)this.fn.getAllowedTimestampSkew().toPeriod())));
            }
        }

        @Override
        public WindowingInternals<InputT, OutputT> windowingInternals() {
            return new WindowingInternals<InputT, OutputT>(){

                @Override
                public void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
                    DoFnProcessContext.this.context.outputWindowedValue(output, timestamp, windows, pane);
                }

                @Override
                public <AdditionalOutputT> void outputWindowedValue(TupleTag<AdditionalOutputT> tag, AdditionalOutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
                    DoFnProcessContext.this.context.outputWindowedValue(tag, output, timestamp, windows, pane);
                }

                @Override
                public Collection<? extends BoundedWindow> windows() {
                    return DoFnProcessContext.this.windowedValue.getWindows();
                }

                @Override
                public PaneInfo pane() {
                    return DoFnProcessContext.this.windowedValue.getPane();
                }

                @Override
                public TimerInternals timerInternals() {
                    return DoFnProcessContext.this.context.stepContext.timerInternals();
                }

                @Override
                public StateInternals stateInternals() {
                    return DoFnProcessContext.this.context.stepContext.stateInternals();
                }

                @Override
                public <T> T sideInput(PCollectionView<T> view, BoundedWindow sideInputWindow) {
                    return DoFnProcessContext.this.context.sideInput(view, sideInputWindow);
                }
            };
        }
    }

    private static class DoFnContext<InputT, OutputT>
    extends OldDoFn.Context {
        private static final int MAX_SIDE_OUTPUTS = 1000;
        final PipelineOptions options;
        final OldDoFn<InputT, OutputT> fn;
        final SideInputReader sideInputReader;
        final DoFnRunners.OutputManager outputManager;
        final TupleTag<OutputT> mainOutputTag;
        final ExecutionContext.StepContext stepContext;
        final WindowFn<?, ?> windowFn;
        private Set<TupleTag<?>> outputTags;

        public DoFnContext(PipelineOptions options, OldDoFn<InputT, OutputT> fn, SideInputReader sideInputReader, DoFnRunners.OutputManager outputManager, TupleTag<OutputT> mainOutputTag, List<TupleTag<?>> additionalOutputTags, ExecutionContext.StepContext stepContext, WindowFn<?, ?> windowFn) {
            super(fn);
            this.options = options;
            this.fn = fn;
            this.sideInputReader = sideInputReader;
            this.outputManager = outputManager;
            this.mainOutputTag = mainOutputTag;
            this.outputTags = Sets.newHashSet();
            this.outputTags.add(mainOutputTag);
            for (TupleTag<?> additionalOutputTag : additionalOutputTags) {
                this.outputTags.add(additionalOutputTag);
            }
            this.stepContext = stepContext;
            this.windowFn = windowFn;
        }

        @Override
        public PipelineOptions getPipelineOptions() {
            return this.options;
        }

        <T, W extends BoundedWindow> WindowedValue<T> makeWindowedValue(T output, Instant timestamp, Collection<W> windows, PaneInfo pane) {
            final Instant inputTimestamp = timestamp;
            if (timestamp == null) {
                timestamp = BoundedWindow.TIMESTAMP_MIN_VALUE;
            }
            if (windows == null) {
                try {
                    WindowFn<?, ?> objectWindowFn;
                    WindowFn<?, ?> windowFn = objectWindowFn = this.windowFn;
                    windowFn.getClass();
                    windows = objectWindowFn.assignWindows(new WindowFn.AssignContext(windowFn){

                        public Object element() {
                            throw new UnsupportedOperationException("WindowFn attempted to access input element when none was available");
                        }

                        public Instant timestamp() {
                            if (inputTimestamp == null) {
                                throw new UnsupportedOperationException("WindowFn attempted to access input timestamp when none was available");
                            }
                            return inputTimestamp;
                        }

                        public W window() {
                            throw new UnsupportedOperationException("WindowFn attempted to access input windows when none were available");
                        }
                    });
                }
                catch (Exception e) {
                    throw UserCodeException.wrap((Throwable)e);
                }
            }
            return WindowedValue.of(output, (Instant)timestamp, windows, (PaneInfo)pane);
        }

        public <T> T sideInput(PCollectionView<T> view, BoundedWindow sideInputWindow) {
            if (!this.sideInputReader.contains(view)) {
                throw new IllegalArgumentException("calling sideInput() with unknown view");
            }
            return this.sideInputReader.get(view, sideInputWindow);
        }

        void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
            this.outputWindowedValue(this.makeWindowedValue(output, timestamp, windows, pane));
        }

        void outputWindowedValue(WindowedValue<OutputT> windowedElem) {
            this.outputManager.output(this.mainOutputTag, windowedElem);
            if (this.stepContext != null) {
                this.stepContext.noteOutput(windowedElem);
            }
        }

        private <T> void outputWindowedValue(TupleTag<T> tag, T output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
            this.outputWindowedValue(tag, this.makeWindowedValue(output, timestamp, windows, pane));
        }

        private <T> void outputWindowedValue(TupleTag<T> tag, WindowedValue<T> windowedElem) {
            if (!this.outputTags.contains(tag)) {
                if (this.outputTags.size() >= 1000) {
                    throw new IllegalArgumentException("the number of outputs has exceeded a limit of 1000");
                }
                this.outputTags.add(tag);
            }
            this.outputManager.output(tag, windowedElem);
            if (this.stepContext != null) {
                this.stepContext.noteOutput(tag, windowedElem);
            }
        }

        @Override
        public void output(OutputT output) {
            this.outputWindowedValue(output, null, null, PaneInfo.NO_FIRING);
        }

        @Override
        public void outputWithTimestamp(OutputT output, Instant timestamp) {
            this.outputWindowedValue(output, timestamp, null, PaneInfo.NO_FIRING);
        }

        @Override
        public <T> void output(TupleTag<T> tag, T output) {
            Preconditions.checkNotNull(tag, "TupleTag passed to output cannot be null");
            this.outputWindowedValue(tag, output, null, null, PaneInfo.NO_FIRING);
        }

        @Override
        public <T> void outputWithTimestamp(TupleTag<T> tag, T output, Instant timestamp) {
            Preconditions.checkNotNull(tag, "TupleTag passed to outputWithTimestamp cannot be null");
            this.outputWindowedValue(tag, output, timestamp, null, PaneInfo.NO_FIRING);
        }
    }
}

