/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.runners.direct.repackaged.javax.annotation.Nullable;
import org.apache.beam.runners.direct.repackaged.runners.core.AutoValue_TimerInternals_TimerData;
import org.apache.beam.runners.direct.repackaged.runners.core.StateNamespace;
import org.apache.beam.runners.direct.repackaged.runners.core.StateNamespaces;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.ComparisonChain;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.joda.time.Instant;

public interface TimerInternals {
    public void setTimer(StateNamespace var1, String var2, Instant var3, TimeDomain var4);

    @Deprecated
    public void setTimer(TimerData var1);

    public void deleteTimer(StateNamespace var1, String var2, TimeDomain var3);

    @Deprecated
    public void deleteTimer(StateNamespace var1, String var2);

    @Deprecated
    public void deleteTimer(TimerData var1);

    public Instant currentProcessingTime();

    @Nullable
    public Instant currentSynchronizedProcessingTime();

    public Instant currentInputWatermarkTime();

    @Nullable
    public Instant currentOutputWatermarkTime();

    public static class TimerDataCoder
    extends StructuredCoder<TimerData> {
        private static final StringUtf8Coder STRING_CODER = StringUtf8Coder.of();
        private static final InstantCoder INSTANT_CODER = InstantCoder.of();
        private final Coder<? extends BoundedWindow> windowCoder;

        public static TimerDataCoder of(Coder<? extends BoundedWindow> windowCoder) {
            return new TimerDataCoder(windowCoder);
        }

        private TimerDataCoder(Coder<? extends BoundedWindow> windowCoder) {
            this.windowCoder = windowCoder;
        }

        public void encode(TimerData timer, OutputStream outStream) throws CoderException, IOException {
            STRING_CODER.encode(timer.getTimerId(), outStream);
            STRING_CODER.encode(timer.getNamespace().stringKey(), outStream);
            INSTANT_CODER.encode(timer.getTimestamp(), outStream);
            STRING_CODER.encode(timer.getDomain().name(), outStream);
        }

        public TimerData decode(InputStream inStream) throws CoderException, IOException {
            String timerId = STRING_CODER.decode(inStream);
            StateNamespace namespace = StateNamespaces.fromString(STRING_CODER.decode(inStream), this.windowCoder);
            Instant timestamp = INSTANT_CODER.decode(inStream);
            TimeDomain domain = TimeDomain.valueOf((String)STRING_CODER.decode(inStream));
            return TimerData.of(timerId, namespace, timestamp, domain);
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.windowCoder);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            TimerDataCoder.verifyDeterministic((Coder)this, (String)"window coder must be deterministic", (Coder[])new Coder[]{this.windowCoder});
        }
    }

    public static abstract class TimerData
    implements Comparable<TimerData> {
        public abstract String getTimerId();

        public abstract StateNamespace getNamespace();

        public abstract Instant getTimestamp();

        public abstract TimeDomain getDomain();

        public static TimerData of(String timerId, StateNamespace namespace, Instant timestamp, TimeDomain domain) {
            return new AutoValue_TimerInternals_TimerData(timerId, namespace, timestamp, domain);
        }

        public static TimerData of(StateNamespace namespace, Instant timestamp, TimeDomain domain) {
            String timerId = "" + domain.ordinal() + ':' + timestamp.getMillis();
            return TimerData.of(timerId, namespace, timestamp, domain);
        }

        @Override
        public int compareTo(TimerData that) {
            if (this.equals(that)) {
                return 0;
            }
            ComparisonChain chain = ComparisonChain.start().compare((Comparable<?>)this.getTimestamp(), (Comparable<?>)that.getTimestamp()).compare((Comparable<?>)this.getDomain(), (Comparable<?>)that.getDomain());
            if (chain.result() == 0 && !this.getNamespace().equals(that.getNamespace())) {
                chain = chain.compare((Comparable<?>)((Object)this.getNamespace().stringKey()), (Comparable<?>)((Object)that.getNamespace().stringKey()));
            }
            return chain.result();
        }
    }
}

