/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.construction;

import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.Any;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.ByteString;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.BytesValue;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.SdkComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.Triggers;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.Duration;

public class WindowingStrategies
implements Serializable {
    public static final String CUSTOM_WINDOWFN_URN = "urn:beam:windowfn:javasdk:0.1";

    public static WindowingStrategy.AccumulationMode fromProto(RunnerApi.AccumulationMode proto) {
        switch (proto) {
            case DISCARDING: {
                return WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES;
            }
            case ACCUMULATING: {
                return WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.AccumulationMode.class.getCanonicalName(), WindowingStrategy.AccumulationMode.class.getCanonicalName(), proto));
    }

    public static RunnerApi.AccumulationMode toProto(WindowingStrategy.AccumulationMode accumulationMode) {
        switch (accumulationMode) {
            case DISCARDING_FIRED_PANES: {
                return RunnerApi.AccumulationMode.DISCARDING;
            }
            case ACCUMULATING_FIRED_PANES: {
                return RunnerApi.AccumulationMode.ACCUMULATING;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", WindowingStrategy.AccumulationMode.class.getCanonicalName(), RunnerApi.AccumulationMode.class.getCanonicalName(), accumulationMode));
    }

    public static RunnerApi.ClosingBehavior toProto(Window.ClosingBehavior closingBehavior) {
        switch (closingBehavior) {
            case FIRE_ALWAYS: {
                return RunnerApi.ClosingBehavior.EMIT_ALWAYS;
            }
            case FIRE_IF_NON_EMPTY: {
                return RunnerApi.ClosingBehavior.EMIT_IF_NONEMPTY;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", Window.ClosingBehavior.class.getCanonicalName(), RunnerApi.ClosingBehavior.class.getCanonicalName(), closingBehavior));
    }

    public static Window.ClosingBehavior fromProto(RunnerApi.ClosingBehavior proto) {
        switch (proto) {
            case EMIT_ALWAYS: {
                return Window.ClosingBehavior.FIRE_ALWAYS;
            }
            case EMIT_IF_NONEMPTY: {
                return Window.ClosingBehavior.FIRE_IF_NON_EMPTY;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.ClosingBehavior.class.getCanonicalName(), Window.ClosingBehavior.class.getCanonicalName(), proto));
    }

    public static RunnerApi.OutputTime toProto(TimestampCombiner timestampCombiner) {
        switch (timestampCombiner) {
            case EARLIEST: {
                return RunnerApi.OutputTime.EARLIEST_IN_PANE;
            }
            case END_OF_WINDOW: {
                return RunnerApi.OutputTime.END_OF_WINDOW;
            }
            case LATEST: {
                return RunnerApi.OutputTime.LATEST_IN_PANE;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s: %s", TimestampCombiner.class.getSimpleName(), timestampCombiner));
    }

    public static TimestampCombiner timestampCombinerFromProto(RunnerApi.OutputTime proto) {
        switch (proto) {
            case EARLIEST_IN_PANE: {
                return TimestampCombiner.EARLIEST;
            }
            case END_OF_WINDOW: {
                return TimestampCombiner.END_OF_WINDOW;
            }
            case LATEST_IN_PANE: {
                return TimestampCombiner.LATEST;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.OutputTime.class.getCanonicalName(), RunnerApi.OutputTime.class.getCanonicalName(), proto));
    }

    public static RunnerApi.SdkFunctionSpec toProto(WindowFn<?, ?> windowFn, SdkComponents components) throws IOException {
        return RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_WINDOWFN_URN).setParameter(Any.pack(BytesValue.newBuilder().setValue(ByteString.copyFrom(SerializableUtils.serializeToByteArray(windowFn))).build()))).build();
    }

    public static RunnerApi.MessageWithComponents toProto(WindowingStrategy<?, ?> windowingStrategy) throws IOException {
        SdkComponents components = SdkComponents.create();
        RunnerApi.WindowingStrategy windowingStrategyProto = WindowingStrategies.toProto(windowingStrategy, components);
        return RunnerApi.MessageWithComponents.newBuilder().setWindowingStrategy(windowingStrategyProto).setComponents(components.toComponents()).build();
    }

    public static RunnerApi.WindowingStrategy toProto(WindowingStrategy<?, ?> windowingStrategy, SdkComponents components) throws IOException {
        RunnerApi.SdkFunctionSpec windowFnSpec = WindowingStrategies.toProto(windowingStrategy.getWindowFn(), components);
        RunnerApi.WindowingStrategy.Builder windowingStrategyProto = RunnerApi.WindowingStrategy.newBuilder().setOutputTime(WindowingStrategies.toProto(windowingStrategy.getTimestampCombiner())).setAccumulationMode(WindowingStrategies.toProto(windowingStrategy.getMode())).setClosingBehavior(WindowingStrategies.toProto(windowingStrategy.getClosingBehavior())).setAllowedLateness(windowingStrategy.getAllowedLateness().getMillis()).setTrigger(Triggers.toProto(windowingStrategy.getTrigger())).setWindowFn(windowFnSpec).setWindowCoderId(components.registerCoder(windowingStrategy.getWindowFn().windowCoder()));
        return windowingStrategyProto.build();
    }

    public static WindowingStrategy<?, ?> fromProto(RunnerApi.MessageWithComponents proto) throws InvalidProtocolBufferException {
        switch (proto.getRootCase()) {
            case WINDOWING_STRATEGY: {
                return WindowingStrategies.fromProto(proto.getWindowingStrategy(), proto.getComponents());
            }
        }
        throw new IllegalArgumentException(String.format("Expected a %s with components but received %s", RunnerApi.WindowingStrategy.class.getCanonicalName(), proto));
    }

    public static WindowingStrategy<?, ?> fromProto(RunnerApi.WindowingStrategy proto, RunnerApi.Components components) throws InvalidProtocolBufferException {
        RunnerApi.SdkFunctionSpec windowFnSpec = proto.getWindowFn();
        Preconditions.checkArgument(windowFnSpec.getSpec().getUrn().equals(CUSTOM_WINDOWFN_URN), "Only Java-serialized %s instances are supported, with URN %s. But found URN %s", (Object)WindowFn.class.getSimpleName(), (Object)CUSTOM_WINDOWFN_URN, (Object)windowFnSpec.getSpec().getUrn());
        Object deserializedWindowFn = SerializableUtils.deserializeFromByteArray((byte[])windowFnSpec.getSpec().getParameter().unpack(BytesValue.class).getValue().toByteArray(), (String)"WindowFn");
        WindowFn windowFn = (WindowFn)deserializedWindowFn;
        TimestampCombiner timestampCombiner = WindowingStrategies.timestampCombinerFromProto(proto.getOutputTime());
        WindowingStrategy.AccumulationMode accumulationMode = WindowingStrategies.fromProto(proto.getAccumulationMode());
        Trigger trigger = Triggers.fromProto(proto.getTrigger());
        Window.ClosingBehavior closingBehavior = WindowingStrategies.fromProto(proto.getClosingBehavior());
        Duration allowedLateness = Duration.millis((long)proto.getAllowedLateness());
        return WindowingStrategy.of((WindowFn)windowFn).withAllowedLateness(allowedLateness).withMode(accumulationMode).withTrigger(trigger).withTimestampCombiner(timestampCombiner).withClosingBehavior(closingBehavior);
    }
}

