/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.ReadableInstant;

public class GroupByKeyViaGroupByKeyOnly<K, V>
extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
    private final GroupByKey<K, V> gbkTransform;

    public GroupByKeyViaGroupByKeyOnly(GroupByKey<K, V> originalTransform) {
        this.gbkTransform = originalTransform;
    }

    public PCollection<KV<K, Iterable<V>>> expand(PCollection<KV<K, V>> input) {
        WindowingStrategy windowingStrategy = input.getWindowingStrategy();
        return ((PCollection)((PCollection)((PCollection)input.apply(new GroupByKeyOnly())).apply(new SortValuesByTimestamp())).apply(new GroupAlsoByWindow(windowingStrategy))).setWindowingStrategyInternal(this.gbkTransform.updateWindowingStrategy(windowingStrategy));
    }

    public static class GroupAlsoByWindow<K, V>
    extends PTransform<PCollection<KV<K, Iterable<WindowedValue<V>>>>, PCollection<KV<K, Iterable<V>>>> {
        private final WindowingStrategy<?, ?> windowingStrategy;

        public GroupAlsoByWindow(WindowingStrategy<?, ?> windowingStrategy) {
            this.windowingStrategy = windowingStrategy;
        }

        public WindowingStrategy<?, ?> getWindowingStrategy() {
            return this.windowingStrategy;
        }

        private KvCoder<K, Iterable<WindowedValue<V>>> getKvCoder(Coder<KV<K, Iterable<WindowedValue<V>>>> inputCoder) {
            Preconditions.checkArgument(inputCoder instanceof KvCoder, "%s requires a %s<...> but got %s", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)KvCoder.class.getSimpleName(), inputCoder);
            KvCoder kvCoder = (KvCoder)inputCoder;
            return kvCoder;
        }

        public Coder<K> getKeyCoder(Coder<KV<K, Iterable<WindowedValue<V>>>> inputCoder) {
            return this.getKvCoder(inputCoder).getKeyCoder();
        }

        public Coder<V> getValueCoder(Coder<KV<K, Iterable<WindowedValue<V>>>> inputCoder) {
            Coder iterableWindowedValueCoder = this.getKvCoder(inputCoder).getValueCoder();
            Preconditions.checkArgument(iterableWindowedValueCoder instanceof IterableCoder, "%s requires a %s<..., %s> but got a %s", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)KvCoder.class.getSimpleName(), (Object)IterableCoder.class.getSimpleName(), (Object)iterableWindowedValueCoder);
            IterableCoder iterableCoder = (IterableCoder)iterableWindowedValueCoder;
            Coder iterableElementCoder = iterableCoder.getElemCoder();
            Preconditions.checkArgument(iterableElementCoder instanceof WindowedValue.WindowedValueCoder, "%s requires a %s<..., %s<%s>> but got a %s", ((Object)((Object)this)).getClass().getSimpleName(), KvCoder.class.getSimpleName(), IterableCoder.class.getSimpleName(), WindowedValue.WindowedValueCoder.class.getSimpleName(), iterableElementCoder);
            WindowedValue.WindowedValueCoder windowedValueCoder = (WindowedValue.WindowedValueCoder)iterableElementCoder;
            return windowedValueCoder.getValueCoder();
        }

        public PCollection<KV<K, Iterable<V>>> expand(PCollection<KV<K, Iterable<WindowedValue<V>>>> input) {
            KvCoder inputKvCoder = (KvCoder)input.getCoder();
            Coder keyCoder = inputKvCoder.getKeyCoder();
            Coder inputValueCoder = inputKvCoder.getValueCoder();
            IterableCoder inputIterableValueCoder = (IterableCoder)inputValueCoder;
            Coder inputIterableElementCoder = inputIterableValueCoder.getElemCoder();
            WindowedValue.WindowedValueCoder inputIterableWindowedValueCoder = (WindowedValue.WindowedValueCoder)inputIterableElementCoder;
            Coder inputIterableElementValueCoder = inputIterableWindowedValueCoder.getValueCoder();
            IterableCoder outputValueCoder = IterableCoder.of((Coder)inputIterableElementValueCoder);
            KvCoder outputKvCoder = KvCoder.of((Coder)keyCoder, (Coder)outputValueCoder);
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), this.windowingStrategy, (PCollection.IsBounded)input.isBounded(), (Coder)outputKvCoder);
        }
    }

    private static class SortValuesByTimestamp<K, V>
    extends PTransform<PCollection<KV<K, Iterable<WindowedValue<V>>>>, PCollection<KV<K, Iterable<WindowedValue<V>>>>> {
        private SortValuesByTimestamp() {
        }

        public PCollection<KV<K, Iterable<WindowedValue<V>>>> expand(PCollection<KV<K, Iterable<WindowedValue<V>>>> input) {
            return ((PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<KV<K, Iterable<WindowedValue<V>>>, KV<K, Iterable<WindowedValue<V>>>>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    KV kvs = (KV)c.element();
                    Object key = kvs.getKey();
                    Iterable unsortedValues = (Iterable)kvs.getValue();
                    ArrayList<WindowedValue> sortedValues = new ArrayList<WindowedValue>();
                    for (WindowedValue value : unsortedValues) {
                        sortedValues.add(value);
                    }
                    Collections.sort(sortedValues, new Comparator<WindowedValue<V>>(){

                        @Override
                        public int compare(WindowedValue<V> e1, WindowedValue<V> e2) {
                            return e1.getTimestamp().compareTo((ReadableInstant)e2.getTimestamp());
                        }
                    });
                    c.output((Object)KV.of((Object)key, sortedValues));
                }
            }))).setCoder(input.getCoder());
        }
    }

    public static class GroupByKeyOnly<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<WindowedValue<V>>>>> {
        public PCollection<KV<K, Iterable<WindowedValue<V>>>> expand(PCollection<KV<K, V>> input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)input.getWindowingStrategy(), (PCollection.IsBounded)input.isBounded(), (Coder)GroupByKey.getOutputKvCoder((Coder)input.getCoder()));
        }
    }
}

