/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.ByteString;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.CoderTranslation;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.SdkComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.TransformInputs;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.runners.direct.repackaged.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.AppliedCombineFn;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;

public class CombineTranslation {
    public static final String JAVA_SERIALIZED_COMBINE_FN_URN = "urn:beam:combinefn:javasdk:v1";

    public static RunnerApi.CombinePayload toProto(AppliedPTransform<?, ?, Combine.PerKey<?, ?, ?>> combine, SdkComponents sdkComponents) throws IOException {
        CombineFnBase.GlobalCombineFn combineFn = ((Combine.PerKey)combine.getTransform()).getFn();
        try {
            Coder accumulatorCoder = CombineTranslation.extractAccumulatorCoder(combineFn, combine);
            HashMap<String, RunnerApi.SideInput> sideInputs = new HashMap<String, RunnerApi.SideInput>();
            return RunnerApi.CombinePayload.newBuilder().setAccumulatorCoderId(sdkComponents.registerCoder(accumulatorCoder)).putAllSideInputs(sideInputs).setCombineFn(CombineTranslation.toProto(combineFn)).build();
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalStateException(e);
        }
    }

    private static <K, InputT, AccumT> Coder<AccumT> extractAccumulatorCoder(CombineFnBase.GlobalCombineFn<InputT, AccumT, ?> combineFn, AppliedPTransform<PCollection<KV<K, InputT>>, ?, Combine.PerKey<K, InputT, ?>> transform) throws CannotProvideCoderException {
        PCollection mainInput = (PCollection)Iterables.getOnlyElement(TransformInputs.nonAdditionalInputs(transform));
        KvCoder inputCoder = (KvCoder)mainInput.getCoder();
        return AppliedCombineFn.withInputCoder(combineFn, (CoderRegistry)transform.getPipeline().getCoderRegistry(), (KvCoder)inputCoder, (Iterable)((Combine.PerKey)transform.getTransform()).getSideInputs(), (WindowingStrategy)((PCollection)Iterables.getOnlyElement(transform.getOutputs().values())).getWindowingStrategy()).getAccumulatorCoder();
    }

    public static RunnerApi.SdkFunctionSpec toProto(CombineFnBase.GlobalCombineFn<?, ?, ?> combineFn) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(JAVA_SERIALIZED_COMBINE_FN_URN).setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray(combineFn))).build()).build();
    }

    public static Coder<?> getAccumulatorCoder(RunnerApi.CombinePayload payload, RehydratedComponents components) throws IOException {
        String id = payload.getAccumulatorCoderId();
        return components.getCoder(id);
    }

    public static Coder<?> getAccumulatorCoder(AppliedPTransform<?, ?, ?> transform) throws IOException {
        SdkComponents sdkComponents = SdkComponents.create();
        String id = CombineTranslation.getCombinePayload(transform, sdkComponents).getAccumulatorCoderId();
        RunnerApi.Components components = sdkComponents.toComponents();
        return CoderTranslation.fromProto(components.getCodersOrThrow(id), RehydratedComponents.forComponents(components));
    }

    public static CombineFnBase.GlobalCombineFn<?, ?, ?> getCombineFn(RunnerApi.CombinePayload payload) throws IOException {
        Preconditions.checkArgument(payload.getCombineFn().getSpec().getUrn().equals(JAVA_SERIALIZED_COMBINE_FN_URN));
        return (CombineFnBase.GlobalCombineFn)SerializableUtils.deserializeFromByteArray((byte[])payload.getCombineFn().getSpec().getPayload().toByteArray(), (String)"CombineFn");
    }

    public static CombineFnBase.GlobalCombineFn<?, ?, ?> getCombineFn(AppliedPTransform<?, ?, ?> transform) throws IOException {
        return CombineTranslation.getCombineFn(CombineTranslation.getCombinePayload(transform));
    }

    private static RunnerApi.CombinePayload getCombinePayload(AppliedPTransform<?, ?, ?> transform) throws IOException {
        return CombineTranslation.getCombinePayload(transform, SdkComponents.create());
    }

    private static RunnerApi.CombinePayload getCombinePayload(AppliedPTransform<?, ?, ?> transform, SdkComponents components) throws IOException {
        return RunnerApi.CombinePayload.parseFrom(PTransformTranslation.toProto(transform, Collections.emptyList(), components).getSpec().getPayload());
    }

    public static class CombinePayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Combine.PerKey<?, ?, ?>> {
        public static PTransformTranslation.TransformPayloadTranslator create() {
            return new CombinePayloadTranslator();
        }

        private CombinePayloadTranslator() {
        }

        @Override
        public String getUrn(Combine.PerKey<?, ?, ?> transform) {
            return "urn:beam:transform:combine:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Combine.PerKey<?, ?, ?>> transform, SdkComponents components) throws IOException {
            RunnerApi.CombinePayload payload = CombineTranslation.toProto(transform, components);
            return RunnerApi.FunctionSpec.newBuilder().setUrn("urn:beam:transform:combine:v1").setPayload(payload.toByteString()).build();
        }

        @AutoService(value=TransformPayloadTranslatorRegistrar.class)
        public static class Registrar
        implements TransformPayloadTranslatorRegistrar {
            @Override
            public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
                return Collections.singletonMap(Combine.PerKey.class, new CombinePayloadTranslator());
            }
        }
    }
}

