/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.construction;

import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.ByteString;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.Timestamp;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.util.Durations;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.util.Timestamps;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.SdkComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.TriggerTranslation;
import org.apache.beam.runners.direct.repackaged.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.runners.direct.repackaged.sdk.common.runner.v1.StandardWindowFns;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.Duration;

public class WindowingStrategyTranslation
implements Serializable {
    public static final String GLOBAL_WINDOWS_FN = "beam:windowfn:global_windows:v0.1";
    public static final String FIXED_WINDOWS_FN = "beam:windowfn:fixed_windows:v0.1";
    public static final String SLIDING_WINDOWS_FN = "beam:windowfn:sliding_windows:v0.1";
    public static final String SESSION_WINDOWS_FN = "beam:windowfn:session_windows:v0.1";
    public static final String SERIALIZED_JAVA_WINDOWFN_URN = "beam:windowfn:javasdk:v0.1";
    public static final String OLD_SERIALIZED_JAVA_WINDOWFN_URN = "urn:beam:windowfn:javasdk:0.1";
    private static final boolean USE_OLD_SERIALIZED_JAVA_WINDOWFN_URN = true;

    public static WindowingStrategy.AccumulationMode fromProto(RunnerApi.AccumulationMode.Enum proto) {
        switch (proto) {
            case DISCARDING: {
                return WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES;
            }
            case ACCUMULATING: {
                return WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.AccumulationMode.class.getCanonicalName(), WindowingStrategy.AccumulationMode.class.getCanonicalName(), proto));
    }

    public static RunnerApi.AccumulationMode.Enum toProto(WindowingStrategy.AccumulationMode accumulationMode) {
        switch (accumulationMode) {
            case DISCARDING_FIRED_PANES: {
                return RunnerApi.AccumulationMode.Enum.DISCARDING;
            }
            case ACCUMULATING_FIRED_PANES: {
                return RunnerApi.AccumulationMode.Enum.ACCUMULATING;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", WindowingStrategy.AccumulationMode.class.getCanonicalName(), RunnerApi.AccumulationMode.class.getCanonicalName(), accumulationMode));
    }

    public static RunnerApi.ClosingBehavior.Enum toProto(Window.ClosingBehavior closingBehavior) {
        switch (closingBehavior) {
            case FIRE_ALWAYS: {
                return RunnerApi.ClosingBehavior.Enum.EMIT_ALWAYS;
            }
            case FIRE_IF_NON_EMPTY: {
                return RunnerApi.ClosingBehavior.Enum.EMIT_IF_NONEMPTY;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", Window.ClosingBehavior.class.getCanonicalName(), RunnerApi.ClosingBehavior.class.getCanonicalName(), closingBehavior));
    }

    public static Window.ClosingBehavior fromProto(RunnerApi.ClosingBehavior.Enum proto) {
        switch (proto) {
            case EMIT_ALWAYS: {
                return Window.ClosingBehavior.FIRE_ALWAYS;
            }
            case EMIT_IF_NONEMPTY: {
                return Window.ClosingBehavior.FIRE_IF_NON_EMPTY;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.ClosingBehavior.class.getCanonicalName(), Window.ClosingBehavior.class.getCanonicalName(), proto));
    }

    public static RunnerApi.OnTimeBehavior.Enum toProto(Window.OnTimeBehavior onTimeBehavior) {
        switch (onTimeBehavior) {
            case FIRE_ALWAYS: {
                return RunnerApi.OnTimeBehavior.Enum.FIRE_ALWAYS;
            }
            case FIRE_IF_NON_EMPTY: {
                return RunnerApi.OnTimeBehavior.Enum.FIRE_IF_NONEMPTY;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", Window.OnTimeBehavior.class.getCanonicalName(), RunnerApi.OnTimeBehavior.class.getCanonicalName(), onTimeBehavior));
    }

    public static Window.OnTimeBehavior fromProto(RunnerApi.OnTimeBehavior.Enum proto) {
        switch (proto) {
            case FIRE_ALWAYS: {
                return Window.OnTimeBehavior.FIRE_ALWAYS;
            }
            case FIRE_IF_NONEMPTY: {
                return Window.OnTimeBehavior.FIRE_IF_NON_EMPTY;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.OnTimeBehavior.class.getCanonicalName(), Window.OnTimeBehavior.class.getCanonicalName(), proto));
    }

    public static RunnerApi.OutputTime.Enum toProto(TimestampCombiner timestampCombiner) {
        switch (timestampCombiner) {
            case EARLIEST: {
                return RunnerApi.OutputTime.Enum.EARLIEST_IN_PANE;
            }
            case END_OF_WINDOW: {
                return RunnerApi.OutputTime.Enum.END_OF_WINDOW;
            }
            case LATEST: {
                return RunnerApi.OutputTime.Enum.LATEST_IN_PANE;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s: %s", TimestampCombiner.class.getSimpleName(), timestampCombiner));
    }

    public static TimestampCombiner timestampCombinerFromProto(RunnerApi.OutputTime.Enum proto) {
        switch (proto) {
            case EARLIEST_IN_PANE: {
                return TimestampCombiner.EARLIEST;
            }
            case END_OF_WINDOW: {
                return TimestampCombiner.END_OF_WINDOW;
            }
            case LATEST_IN_PANE: {
                return TimestampCombiner.LATEST;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert unknown %s to %s: %s", RunnerApi.OutputTime.class.getCanonicalName(), RunnerApi.OutputTime.class.getCanonicalName(), proto));
    }

    public static RunnerApi.SdkFunctionSpec toProto(WindowFn<?, ?> windowFn, SdkComponents components) {
        ByteString serializedFn = ByteString.copyFrom(SerializableUtils.serializeToByteArray(windowFn));
        return RunnerApi.SdkFunctionSpec.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(OLD_SERIALIZED_JAVA_WINDOWFN_URN).setPayload(serializedFn).build()).build();
    }

    public static RunnerApi.MessageWithComponents toProto(WindowingStrategy<?, ?> windowingStrategy) throws IOException {
        SdkComponents components = SdkComponents.create();
        RunnerApi.WindowingStrategy windowingStrategyProto = WindowingStrategyTranslation.toProto(windowingStrategy, components);
        return RunnerApi.MessageWithComponents.newBuilder().setWindowingStrategy(windowingStrategyProto).setComponents(components.toComponents()).build();
    }

    public static RunnerApi.WindowingStrategy toProto(WindowingStrategy<?, ?> windowingStrategy, SdkComponents components) throws IOException {
        RunnerApi.SdkFunctionSpec windowFnSpec = WindowingStrategyTranslation.toProto(windowingStrategy.getWindowFn(), components);
        RunnerApi.WindowingStrategy.Builder windowingStrategyProto = RunnerApi.WindowingStrategy.newBuilder().setOutputTime(WindowingStrategyTranslation.toProto(windowingStrategy.getTimestampCombiner())).setAccumulationMode(WindowingStrategyTranslation.toProto(windowingStrategy.getMode())).setClosingBehavior(WindowingStrategyTranslation.toProto(windowingStrategy.getClosingBehavior())).setAllowedLateness(windowingStrategy.getAllowedLateness().getMillis()).setTrigger(TriggerTranslation.toProto(windowingStrategy.getTrigger())).setWindowFn(windowFnSpec).setAssignsToOneWindow(windowingStrategy.getWindowFn().assignsToOneWindow()).setOnTimeBehavior(WindowingStrategyTranslation.toProto(windowingStrategy.getOnTimeBehavior())).setWindowCoderId(components.registerCoder(windowingStrategy.getWindowFn().windowCoder()));
        return windowingStrategyProto.build();
    }

    public static WindowingStrategy<?, ?> fromProto(RunnerApi.MessageWithComponents proto) throws InvalidProtocolBufferException {
        switch (proto.getRootCase()) {
            case WINDOWING_STRATEGY: {
                return WindowingStrategyTranslation.fromProto(proto.getWindowingStrategy(), RehydratedComponents.forComponents(proto.getComponents()));
            }
        }
        throw new IllegalArgumentException(String.format("Expected a %s with components but received %s", RunnerApi.WindowingStrategy.class.getCanonicalName(), proto));
    }

    public static WindowingStrategy<?, ?> fromProto(RunnerApi.WindowingStrategy proto, RehydratedComponents components) throws InvalidProtocolBufferException {
        RunnerApi.SdkFunctionSpec windowFnSpec = proto.getWindowFn();
        WindowFn<?, ?> windowFn = WindowingStrategyTranslation.windowFnFromProto(windowFnSpec);
        TimestampCombiner timestampCombiner = WindowingStrategyTranslation.timestampCombinerFromProto(proto.getOutputTime());
        WindowingStrategy.AccumulationMode accumulationMode = WindowingStrategyTranslation.fromProto(proto.getAccumulationMode());
        Trigger trigger = TriggerTranslation.fromProto(proto.getTrigger());
        Window.ClosingBehavior closingBehavior = WindowingStrategyTranslation.fromProto(proto.getClosingBehavior());
        Duration allowedLateness = Duration.millis((long)proto.getAllowedLateness());
        Window.OnTimeBehavior onTimeBehavior = WindowingStrategyTranslation.fromProto(proto.getOnTimeBehavior());
        return WindowingStrategy.of(windowFn).withAllowedLateness(allowedLateness).withMode(accumulationMode).withTrigger(trigger).withTimestampCombiner(timestampCombiner).withClosingBehavior(closingBehavior).withOnTimeBehavior(onTimeBehavior);
    }

    public static WindowFn<?, ?> windowFnFromProto(RunnerApi.SdkFunctionSpec windowFnSpec) {
        try {
            switch (windowFnSpec.getSpec().getUrn()) {
                case "beam:windowfn:global_windows:v0.1": {
                    return new GlobalWindows();
                }
                case "beam:windowfn:fixed_windows:v0.1": {
                    StandardWindowFns.FixedWindowsPayload fixedParams = null;
                    fixedParams = StandardWindowFns.FixedWindowsPayload.parseFrom(windowFnSpec.getSpec().getPayload());
                    return FixedWindows.of((Duration)Duration.millis((long)Durations.toMillis((org.apache.beam.runners.direct.repackaged.com.google.protobuf.Duration)fixedParams.getSize()))).withOffset(Duration.millis((long)Timestamps.toMillis((Timestamp)fixedParams.getOffset())));
                }
                case "beam:windowfn:sliding_windows:v0.1": {
                    StandardWindowFns.SlidingWindowsPayload slidingParams = StandardWindowFns.SlidingWindowsPayload.parseFrom(windowFnSpec.getSpec().getPayload());
                    return SlidingWindows.of((Duration)Duration.millis((long)Durations.toMillis((org.apache.beam.runners.direct.repackaged.com.google.protobuf.Duration)slidingParams.getSize()))).every(Duration.millis((long)Durations.toMillis((org.apache.beam.runners.direct.repackaged.com.google.protobuf.Duration)slidingParams.getPeriod()))).withOffset(Duration.millis((long)Timestamps.toMillis((Timestamp)slidingParams.getOffset())));
                }
                case "beam:windowfn:session_windows:v0.1": {
                    StandardWindowFns.SessionsPayload sessionParams = StandardWindowFns.SessionsPayload.parseFrom(windowFnSpec.getSpec().getPayload());
                    return Sessions.withGapDuration((Duration)Duration.millis((long)Durations.toMillis((org.apache.beam.runners.direct.repackaged.com.google.protobuf.Duration)sessionParams.getGapSize())));
                }
                case "beam:windowfn:javasdk:v0.1": 
                case "urn:beam:windowfn:javasdk:0.1": {
                    return (WindowFn)SerializableUtils.deserializeFromByteArray((byte[])windowFnSpec.getSpec().getPayload().toByteArray(), (String)"WindowFn");
                }
            }
            throw new IllegalArgumentException("Unknown or unsupported WindowFn: " + windowFnSpec.getSpec().getUrn());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(String.format("%s for %s with URN %s did not contain expected proto message for payload", RunnerApi.FunctionSpec.class.getSimpleName(), WindowFn.class.getSimpleName(), windowFnSpec.getSpec().getUrn()), e);
        }
    }
}

