/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.fn;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.BlockingQueue;
import org.apache.beam.fn.v1.BeamFnApi;
import org.apache.beam.fn.v1.BeamFnControlGrpc;
import org.apache.beam.runners.direct.repackaged.runners.core.fn.FnApiControlClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FnApiControlClientPoolService
extends BeamFnControlGrpc.BeamFnControlImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(FnApiControlClientPoolService.class);
    private final BlockingQueue<FnApiControlClient> clientPool;

    private FnApiControlClientPoolService(BlockingQueue<FnApiControlClient> clientPool) {
        this.clientPool = clientPool;
    }

    public static FnApiControlClientPoolService offeringClientsToPool(BlockingQueue<FnApiControlClient> clientPool) {
        return new FnApiControlClientPoolService(clientPool);
    }

    public StreamObserver<BeamFnApi.InstructionResponse> control(StreamObserver<BeamFnApi.InstructionRequest> requestObserver) {
        LOGGER.info("Beam Fn Control client connected.");
        FnApiControlClient newClient = FnApiControlClient.forRequestObserver(requestObserver);
        try {
            this.clientPool.put(newClient);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return newClient.asResponseObserver();
    }
}

