/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.triggers;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.base.Joiner;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.runners.direct.repackaged.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.runners.direct.repackaged.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.sdk.annotations.Experimental;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterFirstStateMachine
extends TriggerStateMachine {
    AfterFirstStateMachine(List<TriggerStateMachine> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument(subTriggers.size() > 1);
    }

    @SafeVarargs
    public static TriggerStateMachine of(TriggerStateMachine ... triggers) {
        return new AfterFirstStateMachine(Arrays.asList(triggers));
    }

    public static TriggerStateMachine of(Iterable<? extends TriggerStateMachine> triggers) {
        return new AfterFirstStateMachine(ImmutableList.copyOf(triggers));
    }

    @Override
    public void onElement(TriggerStateMachine.OnElementContext c) throws Exception {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokeOnElement(c);
        }
    }

    @Override
    public void onMerge(TriggerStateMachine.OnMergeContext c) throws Exception {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokeOnMerge(c);
        }
        this.updateFinishedStatus(c);
    }

    @Override
    public boolean shouldFire(TriggerStateMachine.TriggerContext context) throws Exception {
        for (ExecutableTriggerStateMachine subtrigger : context.trigger().subTriggers()) {
            if (!context.forTrigger(subtrigger).trigger().isFinished() && !subtrigger.invokeShouldFire(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onFire(TriggerStateMachine.TriggerContext context) throws Exception {
        for (ExecutableTriggerStateMachine subTrigger : context.trigger().subTriggers()) {
            TriggerStateMachine.TriggerContext subContext;
            if (subTrigger.invokeShouldFire(subContext = context.forTrigger(subTrigger))) {
                subTrigger.invokeOnFire(subContext);
                continue;
            }
            subTrigger.invokeClear(subContext);
        }
        context.trigger().setFinished(true);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("AfterFirst.of(");
        Joiner.on(", ").appendTo(builder, (Iterable<?>)this.subTriggers);
        builder.append(")");
        return builder.toString();
    }

    private void updateFinishedStatus(TriggerStateMachine.TriggerContext c) {
        boolean anyFinished = false;
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            anyFinished |= c.forTrigger(subTrigger).trigger().isFinished();
        }
        c.trigger().setFinished(anyFinished);
    }
}

