/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import java.util.Map;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.EmptyInputProvider;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.ReadEvaluatorFactory;
import org.apache.beam.runners.direct.RootInputProvider;
import org.apache.beam.runners.direct.TestStreamEvaluatorFactory;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.PTransformTranslation;
import org.apache.beam.sdk.runners.AppliedPTransform;

class RootProviderRegistry {
    private final Map<String, RootInputProvider<?, ?, ?>> providers;

    public static RootProviderRegistry defaultRegistry(EvaluationContext context) {
        ImmutableMap.Builder defaultProviders = ImmutableMap.builder();
        defaultProviders.put(PTransformTranslation.READ_TRANSFORM_URN, ReadEvaluatorFactory.inputProvider(context)).put("urn:beam:directrunner:transforms:test_stream:v1", new TestStreamEvaluatorFactory.InputProvider(context)).put(PTransformTranslation.FLATTEN_TRANSFORM_URN, new EmptyInputProvider());
        return new RootProviderRegistry(defaultProviders.build());
    }

    private RootProviderRegistry(Map<String, RootInputProvider<?, ?, ?>> providers) {
        this.providers = providers;
    }

    public Collection<CommittedBundle<?>> getInitialInputs(AppliedPTransform<?, ?, ?> transform, int targetParallelism) throws Exception {
        String transformUrn = PTransformTranslation.urnForTransform(transform.getTransform());
        RootInputProvider<?, ?, ?> provider = Preconditions.checkNotNull(this.providers.get(transformUrn), "Tried to get a %s for a transform \"%s\", but there is no such provider", (Object)RootInputProvider.class.getSimpleName(), (Object)transformUrn);
        return provider.getInitialInputs(transform, targetParallelism);
    }
}

