/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.DirectGroupByKey;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.FlattenEvaluatorFactory;
import org.apache.beam.runners.direct.GroupAlsoByWindowEvaluatorFactory;
import org.apache.beam.runners.direct.GroupByKeyOnlyEvaluatorFactory;
import org.apache.beam.runners.direct.MultiStepCombine;
import org.apache.beam.runners.direct.ParDoEvaluator;
import org.apache.beam.runners.direct.ParDoEvaluatorFactory;
import org.apache.beam.runners.direct.ParDoMultiOverrideFactory;
import org.apache.beam.runners.direct.ReadEvaluatorFactory;
import org.apache.beam.runners.direct.SplittableProcessElementsEvaluatorFactory;
import org.apache.beam.runners.direct.StatefulParDoEvaluatorFactory;
import org.apache.beam.runners.direct.TestStreamEvaluatorFactory;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.ViewEvaluatorFactory;
import org.apache.beam.runners.direct.ViewOverrideFactory;
import org.apache.beam.runners.direct.WindowEvaluatorFactory;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.runners.direct.repackaged.runners.core.SplittableParDoViaKeyedWorkItems;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransformEvaluatorRegistry
implements TransformEvaluatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TransformEvaluatorRegistry.class);
    private final Map<String, TransformEvaluatorFactory> factories;
    private final AtomicBoolean finished = new AtomicBoolean(false);

    public static TransformEvaluatorRegistry defaultRegistry(EvaluationContext ctxt) {
        ImmutableMap<String, TransformEvaluatorFactory> primitives = ImmutableMap.builder().put(PTransformTranslation.READ_TRANSFORM_URN, new ReadEvaluatorFactory(ctxt)).put(PTransformTranslation.PAR_DO_TRANSFORM_URN, (ReadEvaluatorFactory)((Object)new ParDoEvaluatorFactory(ctxt, ParDoEvaluator.defaultRunnerFactory(), ParDoEvaluatorFactory.basicDoFnCacheLoader()))).put(PTransformTranslation.FLATTEN_TRANSFORM_URN, new FlattenEvaluatorFactory(ctxt)).put(PTransformTranslation.ASSIGN_WINDOWS_TRANSFORM_URN, (FlattenEvaluatorFactory)((Object)new WindowEvaluatorFactory(ctxt))).put("urn:beam:directrunner:transforms:write_view:v1", (FlattenEvaluatorFactory)((Object)new ViewEvaluatorFactory(ctxt))).put("urn:beam:directrunner:transforms:stateful_pardo:v1", (FlattenEvaluatorFactory)((Object)new StatefulParDoEvaluatorFactory(ctxt))).put("urn:beam:directrunner:transforms:gbko:v1", new GroupByKeyOnlyEvaluatorFactory(ctxt)).put("urn:beam:directrunner:transforms:gabw:v1", (GroupByKeyOnlyEvaluatorFactory)((Object)new GroupAlsoByWindowEvaluatorFactory(ctxt))).put("urn:beam:directrunner:transforms:test_stream:v1", (GroupByKeyOnlyEvaluatorFactory)((Object)new TestStreamEvaluatorFactory(ctxt))).put("urn:beam:directrunner:transforms:merge_accumulators_extract_output:v1", (GroupByKeyOnlyEvaluatorFactory)((Object)new MultiStepCombine.MergeAndExtractAccumulatorOutputEvaluatorFactory(ctxt))).put("urn:beam:runners_core:transforms:splittable_process:v1", (GroupByKeyOnlyEvaluatorFactory)((Object)new SplittableProcessElementsEvaluatorFactory(ctxt))).build();
        return new TransformEvaluatorRegistry(primitives);
    }

    private TransformEvaluatorRegistry(Map<String, TransformEvaluatorFactory> factories) {
        this.factories = factories;
    }

    @Override
    public <InputT> TransformEvaluator<InputT> forApplication(AppliedPTransform<?, ?, ?> application, CommittedBundle<?> inputBundle) throws Exception {
        Preconditions.checkState(!this.finished.get(), "Tried to get an evaluator for a finished TransformEvaluatorRegistry");
        String urn = PTransformTranslation.urnForTransform(application.getTransform());
        TransformEvaluatorFactory factory = Preconditions.checkNotNull(this.factories.get(urn), "No evaluator for PTransform \"%s\"", (Object)urn);
        return factory.forApplication(application, inputBundle);
    }

    @Override
    public void cleanup() throws Exception {
        ArrayList<Exception> thrownInCleanup = new ArrayList<Exception>();
        for (TransformEvaluatorFactory factory : this.factories.values()) {
            try {
                factory.cleanup();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                thrownInCleanup.add(e);
            }
        }
        this.finished.set(true);
        if (!thrownInCleanup.isEmpty()) {
            LOG.error("Exceptions {} thrown while cleaning up evaluators", thrownInCleanup);
            Exception toThrow = null;
            for (Exception e : thrownInCleanup) {
                if (toThrow == null) {
                    toThrow = e;
                    continue;
                }
                toThrow.addSuppressed(e);
            }
            throw toThrow;
        }
    }

    private static class SplittableParDoProcessElementsTranslator
    extends PTransformTranslation.TransformPayloadTranslator.NotSerializable<SplittableParDoViaKeyedWorkItems.ProcessElements<?, ?, ?, ?>> {
        private SplittableParDoProcessElementsTranslator() {
        }

        @Override
        public String getUrn(SplittableParDoViaKeyedWorkItems.ProcessElements<?, ?, ?, ?> transform) {
            return "urn:beam:runners_core:transforms:splittable_process:v1";
        }
    }

    @AutoService(value=TransformPayloadTranslatorRegistrar.class)
    public static class DirectTransformsRegistrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put(DirectGroupByKey.DirectGroupByKeyOnly.class, PTransformTranslation.TransformPayloadTranslator.NotSerializable.forUrn("urn:beam:directrunner:transforms:gbko:v1")).put(DirectGroupByKey.DirectGroupAlsoByWindow.class, PTransformTranslation.TransformPayloadTranslator.NotSerializable.forUrn("urn:beam:directrunner:transforms:gabw:v1")).put(ParDoMultiOverrideFactory.StatefulParDo.class, PTransformTranslation.TransformPayloadTranslator.NotSerializable.forUrn("urn:beam:directrunner:transforms:stateful_pardo:v1")).put(ViewOverrideFactory.WriteView.class, PTransformTranslation.TransformPayloadTranslator.NotSerializable.forUrn("urn:beam:directrunner:transforms:write_view:v1")).put(TestStreamEvaluatorFactory.DirectTestStreamFactory.DirectTestStream.class, PTransformTranslation.TransformPayloadTranslator.NotSerializable.forUrn("urn:beam:directrunner:transforms:test_stream:v1")).put(SplittableParDoViaKeyedWorkItems.ProcessElements.class, PTransformTranslation.TransformPayloadTranslator.NotSerializable.forUrn("urn:beam:runners_core:transforms:splittable_process:v1")).build();
        }

        public Map<String, PTransformTranslation.TransformPayloadTranslator> getTransformRehydrators() {
            return Collections.emptyMap();
        }
    }
}

