/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.construction;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.io.CharStreams;

public class UrnUtils {
    private static final String STANDARD_URNS_PATH = "org/apache/beam/runners/direct/repackaged/model/common_urns.md";
    private static final Pattern URN_REGEX = Pattern.compile("\\b(urn:)?beam:\\S+:v[0-9.]+");
    private static final Set<String> COMMON_URNS = UrnUtils.extractUrnsFromPath("org/apache/beam/runners/direct/repackaged/model/common_urns.md");

    private static Set<String> extractUrnsFromPath(String path) {
        String contents;
        try {
            contents = CharStreams.toString(new InputStreamReader(UrnUtils.class.getClassLoader().getResourceAsStream(path)));
        }
        catch (IOException exn) {
            throw new RuntimeException(exn);
        }
        HashSet<String> urns = new HashSet<String>();
        Matcher m = URN_REGEX.matcher(contents);
        while (m.find()) {
            urns.add(m.group());
        }
        return urns;
    }

    public static String validateCommonUrn(String urn) {
        if (!URN_REGEX.matcher(urn).matches()) {
            throw new IllegalArgumentException(String.format("'%s' does not match '%s'", urn, URN_REGEX));
        }
        if (!COMMON_URNS.contains(urn)) {
            throw new IllegalArgumentException(String.format("'%s' is not found in '%s'", urn, STANDARD_URNS_PATH));
        }
        return urn;
    }
}

