/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.construction.graph;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.runners.direct.repackaged.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.Environments;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.graph.ImmutableExecutableStage;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.collect.Iterables;

public interface ExecutableStage {
    public static final String URN = "beam:runner:executable_stage:v1";

    public RunnerApi.Environment getEnvironment();

    public PipelineNode.PCollectionNode getInputPCollection();

    public Collection<PipelineNode.PCollectionNode> getOutputPCollections();

    public Collection<PipelineNode.PTransformNode> getTransforms();

    default public RunnerApi.PTransform toPTransform() {
        RunnerApi.PTransform.Builder pt = RunnerApi.PTransform.newBuilder();
        pt.putInputs("input", this.getInputPCollection().getId());
        int i = 0;
        for (PipelineNode.PCollectionNode materializedPCollection : this.getOutputPCollections()) {
            pt.putOutputs(String.format("materialized_%s", i), materializedPCollection.getId());
            ++i;
        }
        for (PipelineNode.PTransformNode fusedTransform : this.getTransforms()) {
            pt.addSubtransforms(fusedTransform.getId());
        }
        pt.setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(URN));
        return pt.build();
    }

    public static ExecutableStage fromPTransform(RunnerApi.PTransform ptransform, RunnerApi.Components components) {
        Preconditions.checkArgument(ptransform.getSpec().getUrn().equals(URN));
        Optional<RunnerApi.Environment> environment = Environments.getEnvironment(ptransform.getSubtransforms(0), components);
        Preconditions.checkArgument(environment.isPresent(), "%s with no %s", (Object)ExecutableStage.class.getSimpleName(), (Object)RunnerApi.Environment.class.getSimpleName());
        String inputId = Iterables.getOnlyElement(ptransform.getInputsMap().values());
        PipelineNode.PCollectionNode inputNode = PipelineNode.pCollection(inputId, components.getPcollectionsOrThrow(inputId));
        Collection outputNodes = ptransform.getOutputsMap().values().stream().map(id -> PipelineNode.pCollection(id, components.getPcollectionsOrThrow((String)id))).collect(Collectors.toSet());
        Collection transformNodes = ptransform.getSubtransformsList().stream().map(id -> PipelineNode.pTransform(id, components.getTransformsOrThrow((String)id))).collect(Collectors.toSet());
        return ImmutableExecutableStage.of(environment.get(), inputNode, transformNodes, outputNodes);
    }
}

