/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.construction.graph;

import com.google.auto.value.AutoValue;
import java.util.Set;
import org.apache.beam.runners.direct.repackaged.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.graph.AutoValue_FusedPipeline;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.graph.PipelineNode;

@AutoValue
public abstract class FusedPipeline {
    static FusedPipeline of(Set<ExecutableStage> environmentalStages, Set<PipelineNode.PTransformNode> runnerStages) {
        return new AutoValue_FusedPipeline(environmentalStages, runnerStages);
    }

    public abstract Set<ExecutableStage> getFusedStages();

    public abstract Set<PipelineNode.PTransformNode> getRunnerExecutedTransforms();

    public RunnerApi.Components asComponents(RunnerApi.Components base) {
        RunnerApi.Components.Builder newComponents = base.toBuilder().clearTransforms();
        for (PipelineNode.PTransformNode runnerExecuted : this.getRunnerExecutedTransforms()) {
            newComponents.putTransforms(runnerExecuted.getId(), runnerExecuted.getTransform());
        }
        for (ExecutableStage stage : this.getFusedStages()) {
            for (PipelineNode.PTransformNode fusedTransform : stage.getTransforms()) {
                newComponents.putTransforms(fusedTransform.getId(), fusedTransform.getTransform());
            }
            newComponents.putTransforms(this.stageId(stage, newComponents), stage.toPTransform());
        }
        return newComponents.build();
    }

    private String stageId(ExecutableStage stage, RunnerApi.Components.Builder cbuilder) {
        String name;
        int i = 0;
        do {
            name = String.format("%s/%s.%s", stage.getInputPCollection().getPCollection().getUniqueName(), stage.getEnvironment().getUrl(), i);
            ++i;
        } while (cbuilder.containsTransforms(name));
        return name;
    }
}

