/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.construction.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.runners.direct.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.runners.direct.repackaged.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.Environments;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.graph.PipelineNode;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.graph.MutableNetwork;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.graph.Network;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.graph.NetworkBuilder;

public class QueryablePipeline {
    private final RunnerApi.Components components;
    private final RehydratedComponents rehydratedComponents;
    private final Network<PipelineNode, PipelineEdge> pipelineNetwork;

    public static QueryablePipeline fromComponents(RunnerApi.Components components) {
        return new QueryablePipeline(components);
    }

    private QueryablePipeline(RunnerApi.Components allComponents) {
        this.components = QueryablePipeline.retainOnlyPrimitives(allComponents);
        this.rehydratedComponents = RehydratedComponents.forComponents(this.components);
        this.pipelineNetwork = this.buildNetwork(this.components);
    }

    @VisibleForTesting
    static RunnerApi.Components retainOnlyPrimitives(RunnerApi.Components components) {
        RunnerApi.Components.Builder flattenedBuilder = components.toBuilder();
        flattenedBuilder.clearTransforms();
        for (Map.Entry<String, RunnerApi.PTransform> transformEntry : components.getTransformsMap().entrySet()) {
            RunnerApi.PTransform transform = transformEntry.getValue();
            boolean isPrimitive = QueryablePipeline.isPrimitiveTransform(transform);
            if (!isPrimitive) continue;
            flattenedBuilder.putTransforms(transformEntry.getKey(), transform);
        }
        return flattenedBuilder.build();
    }

    private static boolean isPrimitiveTransform(RunnerApi.PTransform transform) {
        return transform.getSubtransformsCount() == 0 && !transform.getInputsMap().values().containsAll(transform.getOutputsMap().values());
    }

    private MutableNetwork<PipelineNode, PipelineEdge> buildNetwork(RunnerApi.Components components) {
        MutableNetwork<PipelineNode, PipelineEdge> network = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(false).build();
        HashSet<PipelineNode.PCollectionNode> unproducedCollections = new HashSet<PipelineNode.PCollectionNode>();
        for (Map.Entry<String, RunnerApi.PTransform> transformEntry : components.getTransformsMap().entrySet()) {
            String transformId = transformEntry.getKey();
            RunnerApi.PTransform transform = transformEntry.getValue();
            PipelineNode.PTransformNode transformNode = PipelineNode.pTransform(transformId, this.components.getTransformsOrThrow(transformId));
            network.addNode(transformNode);
            for (String string : transform.getOutputsMap().values()) {
                PipelineNode.PCollectionNode producedNode = PipelineNode.pCollection(string, components.getPcollectionsOrThrow(string));
                network.addNode(producedNode);
                network.addEdge(transformNode, producedNode, new PerElementEdge());
                Preconditions.checkState(network.inDegree(producedNode) == 1, "A %s should have exactly one producing %s, %s has %s", (Object)PipelineNode.PCollectionNode.class.getSimpleName(), (Object)PipelineNode.PTransformNode.class.getSimpleName(), (Object)producedNode, network.successors(producedNode));
                unproducedCollections.remove(producedNode);
            }
            for (Map.Entry entry : transform.getInputsMap().entrySet()) {
                String pcollectionId = (String)entry.getValue();
                PipelineNode.PCollectionNode consumedNode = PipelineNode.pCollection(pcollectionId, this.components.getPcollectionsOrThrow(pcollectionId));
                if (network.addNode(consumedNode)) {
                    unproducedCollections.add(consumedNode);
                }
                if (this.getLocalSideInputNames(transform).contains(entry.getKey())) {
                    network.addEdge(consumedNode, transformNode, new SingletonEdge());
                    continue;
                }
                network.addEdge(consumedNode, transformNode, new PerElementEdge());
            }
        }
        Preconditions.checkState(unproducedCollections.isEmpty(), "%ss %s were consumed but never produced", (Object)PipelineNode.PCollectionNode.class.getSimpleName(), unproducedCollections);
        return network;
    }

    private Set<PipelineNode.PCollectionNode> getConsumedAsSideInputs() {
        return this.pipelineNetwork.edges().stream().filter(edge -> !edge.isPerElement()).map(edge -> (PipelineNode.PCollectionNode)this.pipelineNetwork.incidentNodes(edge).source()).collect(Collectors.toSet());
    }

    public Set<PipelineNode.PTransformNode> getRootTransforms() {
        return this.pipelineNetwork.nodes().stream().filter(pipelineNode -> this.pipelineNetwork.inEdges(pipelineNode).isEmpty()).map(pipelineNode -> (PipelineNode.PTransformNode)pipelineNode).collect(Collectors.toSet());
    }

    public PipelineNode.PTransformNode getProducer(PipelineNode.PCollectionNode pcollection) {
        return (PipelineNode.PTransformNode)Iterables.getOnlyElement(this.pipelineNetwork.predecessors(pcollection));
    }

    public Set<PipelineNode.PTransformNode> getPerElementConsumers(PipelineNode.PCollectionNode pCollection) {
        return this.pipelineNetwork.successors(pCollection).stream().filter(consumer -> this.pipelineNetwork.edgesConnecting(pCollection, consumer).stream().anyMatch(PipelineEdge::isPerElement)).map(pipelineNode -> (PipelineNode.PTransformNode)pipelineNode).collect(Collectors.toSet());
    }

    public Set<PipelineNode.PCollectionNode> getOutputPCollections(PipelineNode.PTransformNode ptransform) {
        return this.pipelineNetwork.successors(ptransform).stream().map(pipelineNode -> (PipelineNode.PCollectionNode)pipelineNode).collect(Collectors.toSet());
    }

    public RunnerApi.Components getComponents() {
        return this.components;
    }

    public Collection<PipelineNode.PCollectionNode> getSideInputs(PipelineNode.PTransformNode transform) {
        return this.getLocalSideInputNames(transform.getTransform()).stream().map(localName -> {
            String pcollectionId = transform.getTransform().getInputsOrThrow((String)localName);
            return PipelineNode.pCollection(pcollectionId, this.components.getPcollectionsOrThrow(pcollectionId));
        }).collect(Collectors.toSet());
    }

    private Set<String> getLocalSideInputNames(RunnerApi.PTransform transform) {
        if (PTransformTranslation.PAR_DO_TRANSFORM_URN.equals(transform.getSpec().getUrn())) {
            try {
                return RunnerApi.ParDoPayload.parseFrom(transform.getSpec().getPayload()).getSideInputsMap().keySet();
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptySet();
    }

    public Optional<RunnerApi.Environment> getEnvironment(PipelineNode.PTransformNode parDo) {
        return Environments.getEnvironment(parDo.getId(), this.components);
    }

    private static class SingletonEdge
    implements PipelineEdge {
        private SingletonEdge() {
        }

        @Override
        public boolean isPerElement() {
            return false;
        }
    }

    private static class PerElementEdge
    implements PipelineEdge {
        private PerElementEdge() {
        }

        @Override
        public boolean isPerElement() {
            return true;
        }
    }

    private static interface PipelineEdge {
        public boolean isPerElement();
    }
}

