/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.metrics;

import java.io.Serializable;
import java.util.Map;
import org.apache.beam.runners.direct.repackaged.javax.annotation.Nullable;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.metrics.MetricKey;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.CounterCell;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.DistributionCell;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.GaugeCell;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.MetricCell;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.MetricUpdates;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.MetricsMap;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;

@Experimental(value=Experimental.Kind.METRICS)
public class MetricsContainerImpl
implements Serializable,
MetricsContainer {
    private final String stepName;
    private MetricsMap<MetricName, CounterCell> counters = new MetricsMap<MetricName, CounterCell>(CounterCell::new);
    private MetricsMap<MetricName, DistributionCell> distributions = new MetricsMap<MetricName, DistributionCell>(DistributionCell::new);
    private MetricsMap<MetricName, GaugeCell> gauges = new MetricsMap<MetricName, GaugeCell>(GaugeCell::new);

    public MetricsContainerImpl(String stepName) {
        this.stepName = stepName;
    }

    public CounterCell getCounter(MetricName metricName) {
        return this.counters.get(metricName);
    }

    @Nullable
    public CounterCell tryGetCounter(MetricName metricName) {
        return this.counters.tryGet(metricName);
    }

    public DistributionCell getDistribution(MetricName metricName) {
        return this.distributions.get(metricName);
    }

    @Nullable
    public DistributionCell tryGetDistribution(MetricName metricName) {
        return this.distributions.tryGet(metricName);
    }

    public GaugeCell getGauge(MetricName metricName) {
        return this.gauges.get(metricName);
    }

    @Nullable
    public GaugeCell tryGetGauge(MetricName metricName) {
        return this.gauges.tryGet(metricName);
    }

    private <UpdateT, CellT extends MetricCell<UpdateT>> ImmutableList<MetricUpdates.MetricUpdate<UpdateT>> extractUpdates(MetricsMap<MetricName, CellT> cells) {
        ImmutableList.Builder updates = ImmutableList.builder();
        for (Map.Entry<MetricName, CellT> cell : cells.entries()) {
            if (!((MetricCell)cell.getValue()).getDirty().beforeCommit()) continue;
            updates.add(MetricUpdates.MetricUpdate.create(MetricKey.create(this.stepName, cell.getKey()), ((MetricCell)cell.getValue()).getCumulative()));
        }
        return updates.build();
    }

    public MetricUpdates getUpdates() {
        return MetricUpdates.create(this.extractUpdates(this.counters), this.extractUpdates(this.distributions), this.extractUpdates(this.gauges));
    }

    private void commitUpdates(MetricsMap<MetricName, ? extends MetricCell<?>> cells) {
        for (MetricCell<?> cell : cells.values()) {
            cell.getDirty().afterCommit();
        }
    }

    public void commitUpdates() {
        this.commitUpdates(this.counters);
        this.commitUpdates(this.distributions);
        this.commitUpdates(this.gauges);
    }

    private <UserT extends Metric, UpdateT, CellT extends MetricCell<UpdateT>> ImmutableList<MetricUpdates.MetricUpdate<UpdateT>> extractCumulatives(MetricsMap<MetricName, CellT> cells) {
        ImmutableList.Builder updates = ImmutableList.builder();
        for (Map.Entry<MetricName, CellT> cell : cells.entries()) {
            Object update = Preconditions.checkNotNull(((MetricCell)cell.getValue()).getCumulative());
            updates.add(MetricUpdates.MetricUpdate.create(MetricKey.create(this.stepName, cell.getKey()), update));
        }
        return updates.build();
    }

    public MetricUpdates getCumulative() {
        return MetricUpdates.create(this.extractCumulatives(this.counters), this.extractCumulatives(this.distributions), this.extractCumulatives(this.gauges));
    }

    public void update(MetricsContainerImpl other) {
        this.updateCounters(this.counters, other.counters);
        this.updateDistributions(this.distributions, other.distributions);
        this.updateGauges(this.gauges, other.gauges);
    }

    private void updateCounters(MetricsMap<MetricName, CounterCell> current, MetricsMap<MetricName, CounterCell> updates) {
        for (Map.Entry<MetricName, CounterCell> counter : updates.entries()) {
            current.get(counter.getKey()).inc(counter.getValue().getCumulative());
        }
    }

    private void updateDistributions(MetricsMap<MetricName, DistributionCell> current, MetricsMap<MetricName, DistributionCell> updates) {
        for (Map.Entry<MetricName, DistributionCell> counter : updates.entries()) {
            current.get(counter.getKey()).update(counter.getValue().getCumulative());
        }
    }

    private void updateGauges(MetricsMap<MetricName, GaugeCell> current, MetricsMap<MetricName, GaugeCell> updates) {
        for (Map.Entry<MetricName, GaugeCell> counter : updates.entries()) {
            current.get(counter.getKey()).update(counter.getValue().getCumulative());
        }
    }
}

