/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.metrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.direct.repackaged.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.metrics.MetricKey;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.cache.CacheBuilder;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.cache.CacheLoader;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.cache.LoadingCache;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.DistributionData;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.GaugeData;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.MetricUpdates;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.MetricName;

@Experimental(value=Experimental.Kind.METRICS)
public abstract class MetricsTranslation {
    private MetricsTranslation() {
    }

    public static MetricUpdates metricUpdatesFromProto(String ptransformName, Collection<BeamFnApi.Metrics.User> userMetricUpdates) {
        ArrayList<MetricUpdates.MetricUpdate<Long>> counterUpdates = new ArrayList<MetricUpdates.MetricUpdate<Long>>();
        ArrayList<MetricUpdates.MetricUpdate<DistributionData>> distributionUpdates = new ArrayList<MetricUpdates.MetricUpdate<DistributionData>>();
        List<MetricUpdates.MetricUpdate<GaugeData>> gaugeUpdates = Collections.emptyList();
        for (BeamFnApi.Metrics.User userMetricUpdate : userMetricUpdates) {
            MetricKey metricKey = MetricKey.create(ptransformName, MetricsTranslation.metricNameFromProto(userMetricUpdate.getMetricName()));
            switch (userMetricUpdate.getDataCase()) {
                case COUNTER_DATA: {
                    counterUpdates.add(MetricUpdates.MetricUpdate.create(metricKey, userMetricUpdate.getCounterData().getValue()));
                    break;
                }
                case DISTRIBUTION_DATA: {
                    distributionUpdates.add(MetricUpdates.MetricUpdate.create(metricKey, DistributionData.create(userMetricUpdate.getDistributionData().getSum(), userMetricUpdate.getDistributionData().getCount(), userMetricUpdate.getDistributionData().getMin(), userMetricUpdate.getDistributionData().getMax())));
                    break;
                }
                case DATA_NOT_SET: {
                    break;
                }
            }
        }
        return MetricUpdates.create(counterUpdates, distributionUpdates, gaugeUpdates);
    }

    public static Map<String, Collection<BeamFnApi.Metrics.User>> metricUpdatesToProto(MetricUpdates metricUpdates) {
        LoadingCache<String, Collection<BeamFnApi.Metrics.User>> fnMetrics = CacheBuilder.newBuilder().build(new CacheLoader<String, Collection<BeamFnApi.Metrics.User>>(){

            @Override
            public Collection<BeamFnApi.Metrics.User> load(String ptransformName) {
                return new ArrayList<BeamFnApi.Metrics.User>();
            }
        });
        for (MetricUpdates.MetricUpdate<Long> metricUpdate : metricUpdates.counterUpdates()) {
            fnMetrics.getUnchecked(metricUpdate.getKey().stepName()).add(BeamFnApi.Metrics.User.newBuilder().setMetricName(MetricsTranslation.metricNameToProto(metricUpdate.getKey().metricName())).setCounterData(BeamFnApi.Metrics.User.CounterData.newBuilder().setValue(metricUpdate.getUpdate().longValue())).build());
        }
        for (MetricUpdates.MetricUpdate<Serializable> metricUpdate : metricUpdates.gaugeUpdates()) {
            fnMetrics.getUnchecked(metricUpdate.getKey().stepName()).add(BeamFnApi.Metrics.User.newBuilder().setMetricName(MetricsTranslation.metricNameToProto(metricUpdate.getKey().metricName())).setGaugeData(BeamFnApi.Metrics.User.GaugeData.newBuilder().setValue(((GaugeData)metricUpdate.getUpdate()).value())).build());
        }
        for (MetricUpdates.MetricUpdate<Serializable> metricUpdate : metricUpdates.distributionUpdates()) {
            fnMetrics.getUnchecked(metricUpdate.getKey().stepName()).add(BeamFnApi.Metrics.User.newBuilder().setMetricName(MetricsTranslation.metricNameToProto(metricUpdate.getKey().metricName())).setDistributionData(BeamFnApi.Metrics.User.DistributionData.newBuilder().setCount(((DistributionData)metricUpdate.getUpdate()).count()).setMax(((DistributionData)metricUpdate.getUpdate()).max()).setMin(((DistributionData)metricUpdate.getUpdate()).min()).setSum(((DistributionData)metricUpdate.getUpdate()).sum())).build());
        }
        return fnMetrics.asMap();
    }

    public static MetricName metricNameFromProto(BeamFnApi.Metrics.User.MetricName protoMetricName) {
        return MetricName.named((String)protoMetricName.getNamespace(), (String)protoMetricName.getName());
    }

    public static BeamFnApi.Metrics.User.MetricName metricNameToProto(MetricName metricName) {
        return BeamFnApi.Metrics.User.MetricName.newBuilder().setNamespace(metricName.namespace()).setName(metricName.name()).build();
    }
}

