/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Strings;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.ByteString;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.InvalidProtocolBufferException;

public class Environments {
    private static final ImmutableMap<String, EnvironmentIdExtractor> KNOWN_URN_SPEC_EXTRACTORS = ImmutableMap.builder().put(PTransformTranslation.COMBINE_PER_KEY_TRANSFORM_URN, Environments::combineExtractor).put(PTransformTranslation.PAR_DO_TRANSFORM_URN, Environments::parDoExtractor).put(PTransformTranslation.SPLITTABLE_PROCESS_ELEMENTS_URN, Environments::parDoExtractor).put(PTransformTranslation.READ_TRANSFORM_URN, Environments::readExtractor).put(PTransformTranslation.ASSIGN_WINDOWS_TRANSFORM_URN, Environments::windowExtractor).build();
    private static final EnvironmentIdExtractor DEFAULT_SPEC_EXTRACTOR = transform -> null;
    private static final String JAVA_SDK_HARNESS_CONTAINER_URL = String.format("%s-docker-apache.bintray.io/beam/java", System.getenv("USER"));
    public static final RunnerApi.Environment JAVA_SDK_HARNESS_ENVIRONMENT = RunnerApi.Environment.newBuilder().setUrl(JAVA_SDK_HARNESS_CONTAINER_URL).build();

    private Environments() {
    }

    public static RunnerApi.Environment createOrGetDefaultEnvironment(String url) {
        if (Strings.isNullOrEmpty(url)) {
            return JAVA_SDK_HARNESS_ENVIRONMENT;
        }
        return RunnerApi.Environment.newBuilder().setUrl(url).build();
    }

    public static Optional<RunnerApi.Environment> getEnvironment(String ptransformId, RunnerApi.Components components) {
        try {
            RunnerApi.PTransform ptransform = components.getTransformsOrThrow(ptransformId);
            String envId = KNOWN_URN_SPEC_EXTRACTORS.getOrDefault(ptransform.getSpec().getUrn(), DEFAULT_SPEC_EXTRACTOR).getEnvironmentId(ptransform);
            if (Strings.isNullOrEmpty(envId)) {
                return Optional.empty();
            }
            return Optional.of(components.getEnvironmentsOrThrow(envId));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<RunnerApi.Environment> getEnvironment(RunnerApi.PTransform ptransform, RehydratedComponents components) {
        try {
            String envId = KNOWN_URN_SPEC_EXTRACTORS.getOrDefault(ptransform.getSpec().getUrn(), DEFAULT_SPEC_EXTRACTOR).getEnvironmentId(ptransform);
            if (!Strings.isNullOrEmpty(envId)) {
                return Optional.of(components.getEnvironment(envId));
            }
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String parDoExtractor(RunnerApi.PTransform pTransform) throws InvalidProtocolBufferException {
        return RunnerApi.ParDoPayload.parseFrom((ByteString)pTransform.getSpec().getPayload()).getDoFn().getEnvironmentId();
    }

    private static String combineExtractor(RunnerApi.PTransform pTransform) throws InvalidProtocolBufferException {
        return RunnerApi.CombinePayload.parseFrom((ByteString)pTransform.getSpec().getPayload()).getCombineFn().getEnvironmentId();
    }

    private static String readExtractor(RunnerApi.PTransform transform) throws InvalidProtocolBufferException {
        return RunnerApi.ReadPayload.parseFrom((ByteString)transform.getSpec().getPayload()).getSource().getEnvironmentId();
    }

    private static String windowExtractor(RunnerApi.PTransform transform) throws InvalidProtocolBufferException {
        return RunnerApi.WindowIntoPayload.parseFrom((ByteString)transform.getSpec().getPayload()).getWindowFn().getEnvironmentId();
    }

    private static interface EnvironmentIdExtractor {
        @Nullable
        public String getEnvironmentId(RunnerApi.PTransform var1) throws IOException;
    }
}

