/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.Sets;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.CombineTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PCollectionViewTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.SdkComponents;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.Timer;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.TimerSpec;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.util.DoFnAndMainOutput;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.ByteString;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.InvalidProtocolBufferException;

public class ParDoTranslation {
    public static final String CUSTOM_JAVA_DO_FN_URN = "urn:beam:dofn:javasdk:0.1";
    public static final String CUSTOM_JAVA_VIEW_FN_URN = "urn:beam:viewfn:javasdk:0.1";
    public static final String CUSTOM_JAVA_WINDOW_MAPPING_FN_URN = "urn:beam:windowmappingfn:javasdk:0.1";

    public static RunnerApi.ParDoPayload translateParDo(final ParDo.MultiOutput<?, ?> parDo, Pipeline pipeline, SdkComponents components) throws IOException {
        String restrictionCoderId;
        final DoFn doFn = parDo.getFn();
        final DoFnSignature signature = DoFnSignatures.getSignature(doFn.getClass());
        if (signature.processElement().isSplittable()) {
            Coder restrictionCoder = DoFnInvokers.invokerFor((DoFn)doFn).invokeGetRestrictionCoder(pipeline.getCoderRegistry());
            restrictionCoderId = components.registerCoder(restrictionCoder);
        } else {
            restrictionCoderId = "";
        }
        return ParDoTranslation.payloadForParDoLike(new ParDoLike(){

            @Override
            public RunnerApi.SdkFunctionSpec translateDoFn(SdkComponents newComponents) {
                return ParDoTranslation.translateDoFn(parDo.getFn(), parDo.getMainOutputTag(), newComponents);
            }

            @Override
            public List<RunnerApi.Parameter> translateParameters() {
                return ParDoTranslation.translateParameters(signature.processElement().extraParameters());
            }

            @Override
            public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents components) {
                HashMap<String, RunnerApi.SideInput> sideInputs = new HashMap<String, RunnerApi.SideInput>();
                for (PCollectionView sideInput : parDo.getSideInputs()) {
                    sideInputs.put(sideInput.getTagInternal().getId(), ParDoTranslation.translateView(sideInput, components));
                }
                return sideInputs;
            }

            @Override
            public Map<String, RunnerApi.StateSpec> translateStateSpecs(SdkComponents components) throws IOException {
                HashMap<String, RunnerApi.StateSpec> stateSpecs = new HashMap<String, RunnerApi.StateSpec>();
                for (Map.Entry state : signature.stateDeclarations().entrySet()) {
                    RunnerApi.StateSpec spec = ParDoTranslation.translateStateSpec(DoFnSignatures.getStateSpecOrThrow((DoFnSignature.StateDeclaration)((DoFnSignature.StateDeclaration)state.getValue()), (DoFn)doFn), components);
                    stateSpecs.put((String)state.getKey(), spec);
                }
                return stateSpecs;
            }

            @Override
            public Map<String, RunnerApi.TimerSpec> translateTimerSpecs(SdkComponents newComponents) {
                HashMap<String, RunnerApi.TimerSpec> timerSpecs = new HashMap<String, RunnerApi.TimerSpec>();
                for (Map.Entry timer : signature.timerDeclarations().entrySet()) {
                    RunnerApi.TimerSpec spec = ParDoTranslation.translateTimerSpec(DoFnSignatures.getTimerSpecOrThrow((DoFnSignature.TimerDeclaration)((DoFnSignature.TimerDeclaration)timer.getValue()), (DoFn)doFn));
                    timerSpecs.put((String)timer.getKey(), spec);
                }
                return timerSpecs;
            }

            @Override
            public boolean isSplittable() {
                return signature.processElement().isSplittable();
            }

            @Override
            public String translateRestrictionCoderId(SdkComponents newComponents) {
                return restrictionCoderId;
            }
        }, components);
    }

    public static List<RunnerApi.Parameter> translateParameters(List<DoFnSignature.Parameter> params) {
        ArrayList<RunnerApi.Parameter> parameters = new ArrayList<RunnerApi.Parameter>();
        for (DoFnSignature.Parameter parameter : params) {
            RunnerApi.Parameter protoParameter = ParDoTranslation.translateParameter(parameter);
            if (protoParameter == null) continue;
            parameters.add(protoParameter);
        }
        return parameters;
    }

    public static DoFn<?, ?> getDoFn(RunnerApi.ParDoPayload payload) throws InvalidProtocolBufferException {
        return ParDoTranslation.doFnAndMainOutputTagFromProto(payload.getDoFn()).getDoFn();
    }

    public static DoFn<?, ?> getDoFn(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getFn();
        }
        return ParDoTranslation.getDoFn(ParDoTranslation.getParDoPayload(application));
    }

    public static TupleTag<?> getMainOutputTag(RunnerApi.ParDoPayload payload) throws InvalidProtocolBufferException {
        return ParDoTranslation.doFnAndMainOutputTagFromProto(payload.getDoFn()).getMainOutputTag();
    }

    public static TupleTag<?> getMainOutputTag(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getMainOutputTag();
        }
        return ParDoTranslation.getMainOutputTag(ParDoTranslation.getParDoPayload(application));
    }

    public static TupleTagList getAdditionalOutputTags(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getAdditionalOutputTags();
        }
        RunnerApi.PTransform protoTransform = PTransformTranslation.toProto(application, SdkComponents.create(application.getPipeline().getOptions()));
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)protoTransform.getSpec().getPayload());
        TupleTag<?> mainOutputTag = ParDoTranslation.getMainOutputTag(payload);
        Sets.SetView<String> outputTags = Sets.difference(protoTransform.getOutputsMap().keySet(), Collections.singleton(mainOutputTag.getId()));
        ArrayList<TupleTag> additionalOutputTags = new ArrayList<TupleTag>();
        for (String outputTag : outputTags) {
            additionalOutputTags.add(new TupleTag(outputTag));
        }
        return TupleTagList.of(additionalOutputTags);
    }

    public static List<PCollectionView<?>> getSideInputs(AppliedPTransform<?, ?, ?> application) throws IOException {
        PTransform transform = application.getTransform();
        if (transform instanceof ParDo.MultiOutput) {
            return ((ParDo.MultiOutput)transform).getSideInputs();
        }
        SdkComponents sdkComponents = SdkComponents.create(application.getPipeline().getOptions());
        RunnerApi.PTransform parDoProto = PTransformTranslation.toProto(application, sdkComponents);
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)parDoProto.getSpec().getPayload());
        ArrayList views = new ArrayList();
        RehydratedComponents components = RehydratedComponents.forComponents(sdkComponents.toComponents());
        for (Map.Entry sideInputEntry : payload.getSideInputsMap().entrySet()) {
            String sideInputTag = (String)sideInputEntry.getKey();
            RunnerApi.SideInput sideInput = (RunnerApi.SideInput)sideInputEntry.getValue();
            PCollection originalPCollection = Preconditions.checkNotNull((PCollection)application.getInputs().get(new TupleTag(sideInputTag)), "no input with tag %s", (Object)sideInputTag);
            views.add(PCollectionViewTranslation.viewFromProto(sideInput, sideInputTag, originalPCollection, parDoProto, components));
        }
        return views;
    }

    public static RunnerApi.PCollection getMainInput(RunnerApi.PTransform ptransform, RunnerApi.Components components) throws IOException {
        Preconditions.checkArgument(ptransform.getSpec().getUrn().equals(PTransformTranslation.PAR_DO_TRANSFORM_URN), "Unexpected payload type %s", (Object)ptransform.getSpec().getUrn());
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)ptransform.getSpec().getPayload());
        return components.getPcollectionsOrThrow(ptransform.getInputsOrThrow(ParDoTranslation.getMainInputId((RunnerApi.PTransformOrBuilder)ptransform, payload)));
    }

    private static String getMainInputId(RunnerApi.PTransformOrBuilder ptransform, RunnerApi.ParDoPayload payload) {
        return (String)Iterables.getOnlyElement(Sets.difference(ptransform.getInputsMap().keySet(), Sets.union(payload.getSideInputsMap().keySet(), payload.getTimerSpecsMap().keySet())));
    }

    public static RunnerApi.StateSpec translateStateSpec(StateSpec<?> stateSpec, final SdkComponents components) throws IOException {
        final RunnerApi.StateSpec.Builder builder = RunnerApi.StateSpec.newBuilder();
        return (RunnerApi.StateSpec)stateSpec.match((StateSpec.Cases)new StateSpec.Cases<RunnerApi.StateSpec>(){

            public RunnerApi.StateSpec dispatchValue(Coder<?> valueCoder) {
                return builder.setValueSpec(RunnerApi.ValueStateSpec.newBuilder().setCoderId(ParDoTranslation.registerCoderOrThrow(components, valueCoder))).build();
            }

            public RunnerApi.StateSpec dispatchBag(Coder<?> elementCoder) {
                return builder.setBagSpec(RunnerApi.BagStateSpec.newBuilder().setElementCoderId(ParDoTranslation.registerCoderOrThrow(components, elementCoder))).build();
            }

            public RunnerApi.StateSpec dispatchCombining(Combine.CombineFn<?, ?, ?> combineFn, Coder<?> accumCoder) {
                return builder.setCombiningSpec(RunnerApi.CombiningStateSpec.newBuilder().setAccumulatorCoderId(ParDoTranslation.registerCoderOrThrow(components, accumCoder)).setCombineFn(CombineTranslation.toProto(combineFn, components))).build();
            }

            public RunnerApi.StateSpec dispatchMap(Coder<?> keyCoder, Coder<?> valueCoder) {
                return builder.setMapSpec(RunnerApi.MapStateSpec.newBuilder().setKeyCoderId(ParDoTranslation.registerCoderOrThrow(components, keyCoder)).setValueCoderId(ParDoTranslation.registerCoderOrThrow(components, valueCoder))).build();
            }

            public RunnerApi.StateSpec dispatchSet(Coder<?> elementCoder) {
                return builder.setSetSpec(RunnerApi.SetStateSpec.newBuilder().setElementCoderId(ParDoTranslation.registerCoderOrThrow(components, elementCoder))).build();
            }
        });
    }

    @VisibleForTesting
    static StateSpec<?> fromProto(RunnerApi.StateSpec stateSpec, RehydratedComponents components) throws IOException {
        switch (stateSpec.getSpecCase()) {
            case VALUE_SPEC: {
                return StateSpecs.value(components.getCoder(stateSpec.getValueSpec().getCoderId()));
            }
            case BAG_SPEC: {
                return StateSpecs.bag(components.getCoder(stateSpec.getBagSpec().getElementCoderId()));
            }
            case COMBINING_SPEC: {
                RunnerApi.FunctionSpec combineFnSpec = stateSpec.getCombiningSpec().getCombineFn().getSpec();
                if (!combineFnSpec.getUrn().equals("urn:beam:combinefn:javasdk:v1")) {
                    throw new UnsupportedOperationException(String.format("Cannot create %s from non-Java %s: %s", StateSpec.class.getSimpleName(), Combine.CombineFn.class.getSimpleName(), combineFnSpec.getUrn()));
                }
                Combine.CombineFn combineFn = (Combine.CombineFn)SerializableUtils.deserializeFromByteArray((byte[])combineFnSpec.getPayload().toByteArray(), (String)Combine.CombineFn.class.getSimpleName());
                return StateSpecs.combining(components.getCoder(stateSpec.getCombiningSpec().getAccumulatorCoderId()), (Combine.CombineFn)combineFn);
            }
            case MAP_SPEC: {
                return StateSpecs.map(components.getCoder(stateSpec.getMapSpec().getKeyCoderId()), components.getCoder(stateSpec.getMapSpec().getValueCoderId()));
            }
            case SET_SPEC: {
                return StateSpecs.set(components.getCoder(stateSpec.getSetSpec().getElementCoderId()));
            }
        }
        throw new IllegalArgumentException(String.format("Unknown %s: %s", RunnerApi.StateSpec.class.getName(), stateSpec));
    }

    private static String registerCoderOrThrow(SdkComponents components, Coder coder) {
        try {
            return components.registerCoder(coder);
        }
        catch (IOException exc) {
            throw new RuntimeException("Failure to register coder", exc);
        }
    }

    public static RunnerApi.TimerSpec translateTimerSpec(TimerSpec timer) {
        return RunnerApi.TimerSpec.newBuilder().setTimeDomain(ParDoTranslation.translateTimeDomain(timer.getTimeDomain())).build();
    }

    private static RunnerApi.TimeDomain.Enum translateTimeDomain(TimeDomain timeDomain) {
        switch (timeDomain) {
            case EVENT_TIME: {
                return RunnerApi.TimeDomain.Enum.EVENT_TIME;
            }
            case PROCESSING_TIME: {
                return RunnerApi.TimeDomain.Enum.PROCESSING_TIME;
            }
            case SYNCHRONIZED_PROCESSING_TIME: {
                return RunnerApi.TimeDomain.Enum.SYNCHRONIZED_PROCESSING_TIME;
            }
        }
        throw new IllegalArgumentException("Unknown time domain");
    }

    public static RunnerApi.SdkFunctionSpec translateDoFn(DoFn<?, ?> fn, TupleTag<?> tag, SdkComponents components) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setEnvironmentId(components.getOnlyEnvironmentId()).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_DO_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray((Serializable)DoFnAndMainOutput.of(fn, tag)))).build()).build();
    }

    public static DoFnAndMainOutput doFnAndMainOutputTagFromProto(RunnerApi.SdkFunctionSpec fnSpec) {
        Preconditions.checkArgument(fnSpec.getSpec().getUrn().equals(CUSTOM_JAVA_DO_FN_URN), "Expected %s to be %s with URN %s, but URN was %s", (Object)DoFn.class.getSimpleName(), (Object)RunnerApi.FunctionSpec.class.getSimpleName(), (Object)CUSTOM_JAVA_DO_FN_URN, (Object)fnSpec.getSpec().getUrn());
        byte[] serializedFn = fnSpec.getSpec().getPayload().toByteArray();
        return (DoFnAndMainOutput)SerializableUtils.deserializeFromByteArray((byte[])serializedFn, (String)"Custom DoFn And Main Output tag");
    }

    @Nullable
    public static RunnerApi.Parameter translateParameter(DoFnSignature.Parameter parameter) {
        return (RunnerApi.Parameter)parameter.match((DoFnSignature.Parameter.Cases)new DoFnSignature.Parameter.Cases.WithDefault<RunnerApi.Parameter>(){

            public RunnerApi.Parameter dispatch(DoFnSignature.Parameter.WindowParameter p) {
                return RunnerApi.Parameter.newBuilder().setType(RunnerApi.Parameter.Type.Enum.WINDOW).build();
            }

            public RunnerApi.Parameter dispatch(DoFnSignature.Parameter.RestrictionTrackerParameter p) {
                return RunnerApi.Parameter.newBuilder().setType(RunnerApi.Parameter.Type.Enum.RESTRICTION_TRACKER).build();
            }

            @Nullable
            protected RunnerApi.Parameter dispatchDefault(DoFnSignature.Parameter p) {
                return null;
            }
        });
    }

    public static Map<String, RunnerApi.SideInput> translateSideInputs(List<PCollectionView<?>> views, SdkComponents components) {
        HashMap<String, RunnerApi.SideInput> sideInputs = new HashMap<String, RunnerApi.SideInput>();
        for (PCollectionView<?> sideInput : views) {
            sideInputs.put(sideInput.getTagInternal().getId(), ParDoTranslation.translateView(sideInput, components));
        }
        return sideInputs;
    }

    public static RunnerApi.SideInput translateView(PCollectionView<?> view, SdkComponents components) {
        RunnerApi.SideInput.Builder builder = RunnerApi.SideInput.newBuilder();
        builder.setAccessPattern(RunnerApi.FunctionSpec.newBuilder().setUrn(view.getViewFn().getMaterialization().getUrn()).build());
        builder.setViewFn(ParDoTranslation.translateViewFn(view.getViewFn(), components));
        builder.setWindowMappingFn(ParDoTranslation.translateWindowMappingFn(view.getWindowMappingFn(), components));
        return builder.build();
    }

    public static RunnerApi.SdkFunctionSpec translateViewFn(ViewFn<?, ?> viewFn, SdkComponents components) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setEnvironmentId(components.getOnlyEnvironmentId()).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_VIEW_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(viewFn))).build()).build();
    }

    private static <T> RunnerApi.ParDoPayload getParDoPayload(AppliedPTransform<?, ?, ?> transform) throws IOException {
        SdkComponents components = SdkComponents.create(transform.getPipeline().getOptions());
        RunnerApi.PTransform parDoPTransform = PTransformTranslation.toProto(transform, Collections.emptyList(), components);
        return RunnerApi.ParDoPayload.parseFrom((ByteString)parDoPTransform.getSpec().getPayload());
    }

    public static boolean usesStateOrTimers(AppliedPTransform<?, ?, ?> transform) throws IOException {
        RunnerApi.ParDoPayload payload = ParDoTranslation.getParDoPayload(transform);
        return payload.getStateSpecsCount() > 0 || payload.getTimerSpecsCount() > 0;
    }

    public static boolean isSplittable(AppliedPTransform<?, ?, ?> transform) throws IOException {
        RunnerApi.ParDoPayload payload = ParDoTranslation.getParDoPayload(transform);
        return payload.getSplittable();
    }

    public static RunnerApi.SdkFunctionSpec translateWindowMappingFn(WindowMappingFn<?> windowMappingFn, SdkComponents components) {
        return RunnerApi.SdkFunctionSpec.newBuilder().setEnvironmentId(components.getOnlyEnvironmentId()).setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(CUSTOM_JAVA_WINDOW_MAPPING_FN_URN).setPayload(ByteString.copyFrom((byte[])SerializableUtils.serializeToByteArray(windowMappingFn))).build()).build();
    }

    public static RunnerApi.ParDoPayload payloadForParDoLike(ParDoLike parDo, SdkComponents components) throws IOException {
        return RunnerApi.ParDoPayload.newBuilder().setDoFn(parDo.translateDoFn(components)).addAllParameters(parDo.translateParameters()).putAllStateSpecs(parDo.translateStateSpecs(components)).putAllTimerSpecs(parDo.translateTimerSpecs(components)).putAllSideInputs(parDo.translateSideInputs(components)).setSplittable(parDo.isSplittable()).setRestrictionCoderId(parDo.translateRestrictionCoderId(components)).build();
    }

    public static interface ParDoLike {
        public RunnerApi.SdkFunctionSpec translateDoFn(SdkComponents var1);

        public List<RunnerApi.Parameter> translateParameters();

        public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents var1);

        public Map<String, RunnerApi.StateSpec> translateStateSpecs(SdkComponents var1) throws IOException;

        public Map<String, RunnerApi.TimerSpec> translateTimerSpecs(SdkComponents var1);

        public boolean isSplittable();

        public String translateRestrictionCoderId(SdkComponents var1);
    }

    public static class ParDoTranslator
    implements PTransformTranslation.TransformTranslator<ParDo.MultiOutput<?, ?>> {
        public static PTransformTranslation.TransformTranslator create() {
            return new ParDoTranslator();
        }

        private ParDoTranslator() {
        }

        @Override
        public String getUrn(ParDo.MultiOutput<?, ?> transform) {
            return PTransformTranslation.PAR_DO_TRANSFORM_URN;
        }

        @Override
        public boolean canTranslate(PTransform<?, ?> pTransform) {
            return pTransform instanceof ParDo.MultiOutput;
        }

        @Override
        public RunnerApi.PTransform translate(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
            RunnerApi.PTransform.Builder builder = PTransformTranslation.translateAppliedPTransform(appliedPTransform, subtransforms, components);
            RunnerApi.ParDoPayload payload = ParDoTranslation.translateParDo((ParDo.MultiOutput)appliedPTransform.getTransform(), appliedPTransform.getPipeline(), components);
            builder.setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(PTransformTranslation.PAR_DO_TRANSFORM_URN).setPayload(payload.toByteString()).build());
            String mainInputId = ParDoTranslation.getMainInputId((RunnerApi.PTransformOrBuilder)builder, payload);
            PCollection mainInput = (PCollection)appliedPTransform.getInputs().get(new TupleTag(mainInputId));
            for (String localTimerName : payload.getTimerSpecsMap().keySet()) {
                PCollection timerPCollection = PCollection.createPrimitiveOutputInternal((Pipeline)Pipeline.create(), (WindowingStrategy)mainInput.getWindowingStrategy(), (PCollection.IsBounded)mainInput.isBounded(), (Coder)KvCoder.of((Coder)((KvCoder)mainInput.getCoder()).getKeyCoder(), (Coder)Timer.Coder.of(VoidCoder.of())));
                timerPCollection.setName(String.format("%s.%s", appliedPTransform.getFullName(), localTimerName));
                String timerPCollectionId = components.registerPCollection(timerPCollection);
                builder.putInputs(localTimerName, timerPCollectionId);
                builder.putOutputs(localTimerName, timerPCollectionId);
            }
            return builder.build();
        }
    }
}

