/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.QueryablePipeline;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.ByteString;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GreedyPCollectionFusers {
    private static final Logger LOG = LoggerFactory.getLogger(GreedyPCollectionFusers.class);
    private static final Map<String, FusibilityChecker> URN_FUSIBILITY_CHECKERS = ImmutableMap.builder().put(PTransformTranslation.PAR_DO_TRANSFORM_URN, GreedyPCollectionFusers::canFuseParDo).put(PTransformTranslation.ASSIGN_WINDOWS_TRANSFORM_URN, GreedyPCollectionFusers::canFuseAssignWindows).put(PTransformTranslation.FLATTEN_TRANSFORM_URN, GreedyPCollectionFusers::canAlwaysFuse).put(PTransformTranslation.GROUP_BY_KEY_TRANSFORM_URN, GreedyPCollectionFusers::cannotFuse).put(PTransformTranslation.CREATE_VIEW_TRANSFORM_URN, GreedyPCollectionFusers::cannotFuse).build();
    private static final FusibilityChecker DEFAULT_FUSIBILITY_CHECKER = GreedyPCollectionFusers::unknownTransformFusion;
    private static final Map<String, CompatibilityChecker> URN_COMPATIBILITY_CHECKERS = ImmutableMap.builder().put(PTransformTranslation.PAR_DO_TRANSFORM_URN, GreedyPCollectionFusers::parDoCompatibility).put(PTransformTranslation.ASSIGN_WINDOWS_TRANSFORM_URN, GreedyPCollectionFusers::compatibleEnvironments).put(PTransformTranslation.FLATTEN_TRANSFORM_URN, GreedyPCollectionFusers::noCompatibility).put(PTransformTranslation.GROUP_BY_KEY_TRANSFORM_URN, GreedyPCollectionFusers::noCompatibility).put(PTransformTranslation.CREATE_VIEW_TRANSFORM_URN, GreedyPCollectionFusers::noCompatibility).build();
    private static final CompatibilityChecker DEFAULT_COMPATIBILITY_CHECKER = GreedyPCollectionFusers::unknownTransformCompatibility;

    GreedyPCollectionFusers() {
    }

    public static boolean canFuse(PipelineNode.PTransformNode transformNode, RunnerApi.Environment environment, Collection<PipelineNode.PCollectionNode> stagePCollections, QueryablePipeline pipeline) {
        return URN_FUSIBILITY_CHECKERS.getOrDefault(transformNode.getTransform().getSpec().getUrn(), DEFAULT_FUSIBILITY_CHECKER).canFuse(transformNode, environment, stagePCollections, pipeline);
    }

    public static boolean isCompatible(PipelineNode.PTransformNode left, PipelineNode.PTransformNode right, QueryablePipeline pipeline) {
        CompatibilityChecker leftChecker = URN_COMPATIBILITY_CHECKERS.getOrDefault(left.getTransform().getSpec().getUrn(), DEFAULT_COMPATIBILITY_CHECKER);
        CompatibilityChecker rightChecker = URN_COMPATIBILITY_CHECKERS.getOrDefault(right.getTransform().getSpec().getUrn(), DEFAULT_COMPATIBILITY_CHECKER);
        return leftChecker.isCompatible(left, right, pipeline) && rightChecker.isCompatible(right, left, pipeline);
    }

    private static boolean canFuseParDo(PipelineNode.PTransformNode parDo, RunnerApi.Environment environment, Collection<PipelineNode.PCollectionNode> stagePCollections, QueryablePipeline pipeline) {
        Optional<RunnerApi.Environment> env = pipeline.getEnvironment(parDo);
        Preconditions.checkArgument(env.isPresent(), "A %s must have an %s associated with it", (Object)RunnerApi.ParDoPayload.class.getSimpleName(), (Object)RunnerApi.Environment.class.getSimpleName());
        if (!env.get().equals((Object)environment)) {
            return false;
        }
        if (!pipeline.getSideInputs(parDo).isEmpty()) {
            return false;
        }
        try {
            RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)parDo.getTransform().getSpec().getPayload());
            if (payload.getStateSpecsCount() > 0 || payload.getTimerSpecsCount() > 0) {
                return false;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
        return true;
    }

    private static boolean parDoCompatibility(PipelineNode.PTransformNode parDo, PipelineNode.PTransformNode other, QueryablePipeline pipeline) {
        return pipeline.getSideInputs(parDo).isEmpty() && pipeline.getUserStates(parDo).isEmpty() && GreedyPCollectionFusers.compatibleEnvironments(parDo, other, pipeline);
    }

    private static boolean canFuseAssignWindows(PipelineNode.PTransformNode window, RunnerApi.Environment environmemnt, Collection<PipelineNode.PCollectionNode> stagePCollections, QueryablePipeline pipeline) {
        Optional<RunnerApi.Environment> windowEnvironment = pipeline.getEnvironment(window);
        return environmemnt.equals(windowEnvironment.orElse(null));
    }

    private static boolean compatibleEnvironments(PipelineNode.PTransformNode left, PipelineNode.PTransformNode right, QueryablePipeline pipeline) {
        return pipeline.getEnvironment(left).equals(pipeline.getEnvironment(right));
    }

    private static boolean canAlwaysFuse(PipelineNode.PTransformNode flatten, RunnerApi.Environment environment, Collection<PipelineNode.PCollectionNode> stagePCollections, QueryablePipeline pipeline) {
        return true;
    }

    private static boolean cannotFuse(PipelineNode.PTransformNode cannotFuse, RunnerApi.Environment environment, Collection<PipelineNode.PCollectionNode> stagePCollections, QueryablePipeline pipeline) {
        return false;
    }

    private static boolean noCompatibility(PipelineNode.PTransformNode self, PipelineNode.PTransformNode other, QueryablePipeline pipeline) {
        return false;
    }

    private static boolean unknownTransformFusion(PipelineNode.PTransformNode transform, RunnerApi.Environment environment, Collection<PipelineNode.PCollectionNode> stagePCollections, QueryablePipeline pipeline) {
        LOG.debug("Unknown {} {} will not fuse into an existing {}", new Object[]{RunnerApi.PTransform.class.getSimpleName(), transform.getTransform(), ExecutableStage.class.getSimpleName(), RunnerApi.PTransform.class.getSimpleName()});
        return false;
    }

    private static boolean unknownTransformCompatibility(PipelineNode.PTransformNode transform, PipelineNode.PTransformNode other, QueryablePipeline pipeline) {
        LOG.debug("Unknown {} {} will not root a {} with other {}", new Object[]{RunnerApi.PTransform.class.getSimpleName(), transform.getTransform(), ExecutableStage.class.getSimpleName(), RunnerApi.PTransform.class.getSimpleName()});
        return false;
    }

    private static interface CompatibilityChecker {
        public boolean isCompatible(PipelineNode.PTransformNode var1, PipelineNode.PTransformNode var2, QueryablePipeline var3);
    }

    private static interface FusibilityChecker {
        public boolean canFuse(PipelineNode.PTransformNode var1, RunnerApi.Environment var2, Collection<PipelineNode.PCollectionNode> var3, QueryablePipeline var4);
    }
}

