/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph;

import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.Set;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.Sets;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.AutoValue_UserStateReference;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.ByteString;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.InvalidProtocolBufferException;

@AutoValue
public abstract class UserStateReference {
    public static UserStateReference of(PipelineNode.PTransformNode transform, String localName, PipelineNode.PCollectionNode collection) {
        return new AutoValue_UserStateReference(transform, localName, collection);
    }

    public static UserStateReference fromUserStateId(RunnerApi.ExecutableStagePayload.UserStateId userStateId, RunnerApi.Components components) {
        String transformId = userStateId.getTransformId();
        String localName = userStateId.getLocalName();
        RunnerApi.PTransform transform = components.getTransformsOrThrow(transformId);
        Set<Object> sideInputNames = Collections.emptySet();
        if (PTransformTranslation.PAR_DO_TRANSFORM_URN.equals(transform.getSpec().getUrn())) {
            try {
                sideInputNames = RunnerApi.ParDoPayload.parseFrom((ByteString)transform.getSpec().getPayload()).getSideInputsMap().keySet();
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
        String collectionId = transform.getInputsOrThrow((String)Iterables.getOnlyElement(Sets.difference(transform.getInputsMap().keySet(), sideInputNames)));
        RunnerApi.PCollection collection = components.getPcollectionsOrThrow(collectionId);
        return UserStateReference.of(PipelineNode.pTransform(transformId, transform), localName, PipelineNode.pCollection(collectionId, collection));
    }

    public abstract PipelineNode.PTransformNode transform();

    public abstract String localName();

    public abstract PipelineNode.PCollectionNode collection();
}

