/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.test;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.beam.repackaged.beam_sdks_java_fn_execution.com.google.common.util.concurrent.ForwardingExecutorService;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestExecutors {
    public static TestExecutorService from(ExecutorService staticExecutorService) {
        return TestExecutors.from(() -> staticExecutorService);
    }

    public static TestExecutorService from(Supplier<ExecutorService> executorServiceSuppler) {
        return new FromSupplier(executorServiceSuppler);
    }

    private static class FromSupplier
    extends ForwardingExecutorService
    implements TestExecutorService {
        private final Supplier<ExecutorService> executorServiceSupplier;
        private ExecutorService delegate;

        private FromSupplier(Supplier<ExecutorService> executorServiceSupplier) {
            this.executorServiceSupplier = executorServiceSupplier;
        }

        public Statement apply(final Statement statement, Description arg1) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    Throwable thrown = null;
                    delegate = (ExecutorService)executorServiceSupplier.get();
                    try {
                        statement.evaluate();
                    }
                    catch (Throwable t) {
                        thrown = t;
                    }
                    this.shutdown();
                    if (!this.awaitTermination(5L, TimeUnit.SECONDS)) {
                        this.shutdownNow();
                        IllegalStateException e = new IllegalStateException("Test executor failed to shutdown cleanly.");
                        if (thrown != null) {
                            thrown.addSuppressed(e);
                        } else {
                            thrown = e;
                        }
                    }
                    if (thrown != null) {
                        throw thrown;
                    }
                }
            };
        }

        @Override
        protected ExecutorService delegate() {
            return this.delegate;
        }
    }

    public static interface TestExecutorService
    extends ExecutorService,
    TestRule {
    }
}

