/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import java.util.Map;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.EmptyInputProvider;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.ImpulseEvaluatorFactory;
import org.apache.beam.runners.direct.ReadEvaluatorFactory;
import org.apache.beam.runners.direct.RootInputProvider;
import org.apache.beam.runners.direct.TestStreamEvaluatorFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;

class RootProviderRegistry {
    private final Map<String, RootInputProvider<?, ?, ?>> providers;

    public static RootProviderRegistry javaNativeRegistry(EvaluationContext context, PipelineOptions options) {
        return new RootProviderRegistry(ImmutableMap.builder().put(PTransformTranslation.IMPULSE_TRANSFORM_URN, new ImpulseEvaluatorFactory.ImpulseRootProvider(context)).put(PTransformTranslation.READ_TRANSFORM_URN, (ImpulseEvaluatorFactory.ImpulseRootProvider)((Object)ReadEvaluatorFactory.inputProvider(context, options))).put("urn:beam:directrunner:transforms:test_stream:v1", new TestStreamEvaluatorFactory.InputProvider(context)).put(PTransformTranslation.FLATTEN_TRANSFORM_URN, new EmptyInputProvider()).build());
    }

    public static RootProviderRegistry impulseRegistry(EvaluationContext context) {
        return new RootProviderRegistry(ImmutableMap.builder().put(PTransformTranslation.IMPULSE_TRANSFORM_URN, new ImpulseEvaluatorFactory.ImpulseRootProvider(context)).build());
    }

    private RootProviderRegistry(Map<String, RootInputProvider<?, ?, ?>> providers) {
        this.providers = providers;
    }

    public Collection<CommittedBundle<?>> getInitialInputs(AppliedPTransform<?, ?, ?> transform, int targetParallelism) throws Exception {
        String transformUrn = PTransformTranslation.urnForTransform(transform.getTransform());
        RootInputProvider<?, ?, ?> provider = Preconditions.checkNotNull(this.providers.get(transformUrn), "Tried to get a %s for a transform \"%s\", but there is no such provider", (Object)RootInputProvider.class.getSimpleName(), (Object)transformUrn);
        return provider.getInitialInputs(transform, targetParallelism);
    }
}

