/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.CaseFormat;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.Message;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.MessageOrBuilder;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.Struct;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.util.JsonFormat;

public class PipelineOptionsTranslation {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));

    public static Struct toProto(PipelineOptions options) {
        Struct.Builder builder = Struct.newBuilder();
        try {
            JsonNode treeNode = MAPPER.valueToTree((Object)options);
            TreeNode rootOptions = treeNode.get("options");
            Iterator optionsKeys = rootOptions.fieldNames();
            HashMap<String, TreeNode> optionsUsingUrns = new HashMap<String, TreeNode>();
            while (optionsKeys.hasNext()) {
                String optionKey = (String)optionsKeys.next();
                TreeNode optionValue = rootOptions.get(optionKey);
                optionsUsingUrns.put("beam:option:" + CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, optionKey) + ":v1", optionValue);
            }
            JsonFormat.parser().merge(MAPPER.writeValueAsString(optionsUsingUrns), (Message.Builder)builder);
            return builder.build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static PipelineOptions fromProto(Struct protoOptions) throws IOException {
        HashMap<String, TreeNode> mapWithoutUrns = new HashMap<String, TreeNode>();
        JsonNode rootOptions = MAPPER.readTree(JsonFormat.printer().print((MessageOrBuilder)protoOptions));
        Iterator optionsKeys = rootOptions.fieldNames();
        while (optionsKeys.hasNext()) {
            String optionKey = (String)optionsKeys.next();
            TreeNode optionValue = rootOptions.get(optionKey);
            mapWithoutUrns.put(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, optionKey.substring("beam:option:".length(), optionKey.length() - ":v1".length())), optionValue);
        }
        return (PipelineOptions)MAPPER.readValue(MAPPER.writeValueAsString(ImmutableMap.of("options", mapWithoutUrns)), PipelineOptions.class);
    }
}

