/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Equivalence;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.BiMap;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.HashBiMap;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.CoderTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.Environments;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PCollectionTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;

public class SdkComponents {
    private final RunnerApi.Components.Builder componentsBuilder = RunnerApi.Components.newBuilder();
    private final BiMap<AppliedPTransform<?, ?, ?>, String> transformIds = HashBiMap.create();
    private final BiMap<PCollection<?>, String> pCollectionIds = HashBiMap.create();
    private final BiMap<WindowingStrategy<?, ?>, String> windowingStrategyIds = HashBiMap.create();
    private final BiMap<Equivalence.Wrapper<? extends Coder<?>>, String> coderIds = HashBiMap.create();
    private final BiMap<RunnerApi.Environment, String> environmentIds = HashBiMap.create();

    public static SdkComponents create() {
        return new SdkComponents();
    }

    public static SdkComponents create(PipelineOptions options) {
        SdkComponents sdkComponents = new SdkComponents();
        sdkComponents.registerEnvironment(Environments.createOrGetDefaultEnvironment(((PortablePipelineOptions)options.as(PortablePipelineOptions.class)).getDefaultJavaEnvironmentUrl()));
        return sdkComponents;
    }

    private SdkComponents() {
    }

    public String registerPTransform(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> children) throws IOException {
        String name = this.getApplicationName(appliedPTransform);
        if (this.componentsBuilder.getTransformsOrDefault(name, null) != null) {
            return name;
        }
        Preconditions.checkNotNull(children, "child nodes may not be null");
        this.componentsBuilder.putTransforms(name, PTransformTranslation.toProto(appliedPTransform, children, this));
        return name;
    }

    private String getApplicationName(AppliedPTransform<?, ?, ?> appliedPTransform) {
        String existing = (String)this.transformIds.get(appliedPTransform);
        if (existing != null) {
            return existing;
        }
        String name = appliedPTransform.getFullName();
        if (name.isEmpty()) {
            name = "unnamed-ptransform";
        }
        name = this.uniqify(name, this.transformIds.values());
        this.transformIds.put(appliedPTransform, name);
        return name;
    }

    String getExistingPTransformId(AppliedPTransform<?, ?, ?> appliedPTransform) {
        Preconditions.checkArgument(this.transformIds.containsKey(appliedPTransform), "%s %s has not been previously registered", (Object)AppliedPTransform.class.getSimpleName(), appliedPTransform);
        return (String)this.transformIds.get(appliedPTransform);
    }

    public String getPTransformIdOrThrow(AppliedPTransform<?, ?, ?> appliedPTransform) {
        String existing = (String)this.transformIds.get(appliedPTransform);
        Preconditions.checkArgument(existing != null, "PTransform id not found for: %s", appliedPTransform);
        return existing;
    }

    public String registerPCollection(PCollection<?> pCollection) throws IOException {
        String existing = (String)this.pCollectionIds.get(pCollection);
        if (existing != null) {
            return existing;
        }
        String uniqueName = this.uniqify(pCollection.getName(), this.pCollectionIds.values());
        this.pCollectionIds.put(pCollection, uniqueName);
        this.componentsBuilder.putPcollections(uniqueName, PCollectionTranslation.toProto(pCollection, this));
        return uniqueName;
    }

    public String registerWindowingStrategy(WindowingStrategy<?, ?> windowingStrategy) throws IOException {
        String existing = (String)this.windowingStrategyIds.get(windowingStrategy);
        if (existing != null) {
            return existing;
        }
        String baseName = String.format("%s(%s)", NameUtils.approximateSimpleName(windowingStrategy), NameUtils.approximateSimpleName((Object)windowingStrategy.getWindowFn()));
        String name = this.uniqify(baseName, this.windowingStrategyIds.values());
        this.windowingStrategyIds.put(windowingStrategy, name);
        RunnerApi.WindowingStrategy windowingStrategyProto = WindowingStrategyTranslation.toProto(windowingStrategy, this);
        this.componentsBuilder.putWindowingStrategies(name, windowingStrategyProto);
        return name;
    }

    public String registerCoder(Coder<?> coder) throws IOException {
        String existing = (String)this.coderIds.get(Equivalence.identity().wrap(coder));
        if (existing != null) {
            return existing;
        }
        String baseName = NameUtils.approximateSimpleName(coder);
        String name = this.uniqify(baseName, this.coderIds.values());
        this.coderIds.put(Equivalence.identity().wrap(coder), name);
        RunnerApi.Coder coderProto = CoderTranslation.toProto(coder, this);
        this.componentsBuilder.putCoders(name, coderProto);
        return name;
    }

    public String registerEnvironment(RunnerApi.Environment env) {
        String existing = (String)this.environmentIds.get(env);
        if (existing != null) {
            return existing;
        }
        String url = env.getUrl();
        String name = this.uniqify(url, this.environmentIds.values());
        this.environmentIds.put(env, name);
        this.componentsBuilder.putEnvironments(name, env);
        return name;
    }

    public String getOnlyEnvironmentId() {
        return (String)Iterables.getOnlyElement(this.componentsBuilder.getEnvironmentsMap().keySet());
    }

    private String uniqify(String baseName, Set<String> existing) {
        String name = baseName;
        int increment = 1;
        while (existing.contains(name)) {
            name = baseName + Integer.toString(increment);
            ++increment;
        }
        return name;
    }

    @Experimental
    public RunnerApi.Components toComponents() {
        return this.componentsBuilder.build();
    }
}

