/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect;

import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.annotations.GwtCompatible;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.Iterators;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.ObjectArrays;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.UnmodifiableListIterator;

@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableList<E>
extends ImmutableList<E> {
    static final ImmutableList<Object> EMPTY = new RegularImmutableList<Object>(ObjectArrays.EMPTY_ARRAY);
    private final transient Object[] array;

    RegularImmutableList(Object[] array) {
        this.array = array;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    int copyIntoArray(Object[] dst, int dstOff) {
        System.arraycopy(this.array, 0, dst, dstOff, this.array.length);
        return dstOff + this.array.length;
    }

    @Override
    public E get(int index) {
        return (E)this.array[index];
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return Iterators.forArray(this.array, 0, this.array.length, index);
    }
}

