/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.metrics;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_core_java.com.google.common.base.MoreObjects;
import org.apache.beam.repackaged.beam_runners_core_java.com.google.common.collect.Iterables;
import org.apache.beam.sdk.annotations.Experimental;

@Experimental(value=Experimental.Kind.METRICS)
public class MetricsMap<K, T>
implements Serializable {
    private final Factory<K, T> factory;
    private final ConcurrentMap<K, T> metrics = new ConcurrentHashMap<K, T>();

    public MetricsMap(Factory<K, T> factory) {
        this.factory = factory;
    }

    public T get(K key) {
        Object metric = this.metrics.get(key);
        if (metric == null) {
            metric = this.factory.createInstance(key);
            metric = MoreObjects.firstNonNull(this.metrics.putIfAbsent(key, metric), metric);
        }
        return (T)metric;
    }

    @Nullable
    public T tryGet(K key) {
        return (T)this.metrics.get(key);
    }

    public Iterable<Map.Entry<K, T>> entries() {
        return Iterables.unmodifiableIterable(this.metrics.entrySet());
    }

    public Iterable<T> values() {
        return Iterables.unmodifiableIterable(this.metrics.values());
    }

    public static interface Factory<K, T>
    extends Serializable {
        public T createInstance(K var1);
    }
}

