/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.portable;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.beam_runners_direct_java.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.ExecutableStage;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction.graph.PipelineNode;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.control.BundleProgressHandler;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.control.JobBundleFactory;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.control.RemoteBundle;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.control.StageBundleFactory;
import org.apache.beam.repackaged.beam_runners_direct_java.runners.fnexecution.state.StateRequestHandler;
import org.apache.beam.repackaged.beam_runners_direct_java.sdk.fn.data.FnDataReceiver;
import org.apache.beam.runners.direct.portable.BundleFactory;
import org.apache.beam.runners.direct.portable.BundleFactoryOutputReceiverFactory;
import org.apache.beam.runners.direct.portable.CommittedBundle;
import org.apache.beam.runners.direct.portable.StepTransformResult;
import org.apache.beam.runners.direct.portable.TransformEvaluator;
import org.apache.beam.runners.direct.portable.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.portable.TransformResult;
import org.apache.beam.runners.direct.portable.UncommittedBundle;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.protobuf.v3.com.google.protobuf.ByteString;

class RemoteStageEvaluatorFactory
implements TransformEvaluatorFactory {
    private final BundleFactory bundleFactory;
    private final JobBundleFactory jobFactory;

    RemoteStageEvaluatorFactory(BundleFactory bundleFactory, JobBundleFactory jobFactory) {
        this.bundleFactory = bundleFactory;
        this.jobFactory = jobFactory;
    }

    @Override
    @Nullable
    public <InputT> TransformEvaluator<InputT> forApplication(PipelineNode.PTransformNode application, CommittedBundle<?> inputBundle) throws Exception {
        return new RemoteStageEvaluator(application);
    }

    @Override
    public void cleanup() throws Exception {
        this.jobFactory.close();
    }

    private class RemoteStageEvaluator<T>
    implements TransformEvaluator<T> {
        private final PipelineNode.PTransformNode transform;
        private final RemoteBundle bundle;
        private final FnDataReceiver<WindowedValue<?>> mainInput;
        private final Collection<UncommittedBundle<?>> outputs;

        private RemoteStageEvaluator(PipelineNode.PTransformNode transform) throws Exception {
            this.transform = transform;
            ExecutableStage stage = ExecutableStage.fromPayload(RunnerApi.ExecutableStagePayload.parseFrom((ByteString)transform.getTransform().getSpec().getPayload()));
            this.outputs = new ArrayList();
            StageBundleFactory stageFactory = RemoteStageEvaluatorFactory.this.jobFactory.forStage(stage);
            this.bundle = stageFactory.getBundle(BundleFactoryOutputReceiverFactory.create(RemoteStageEvaluatorFactory.this.bundleFactory, stage.getComponents(), this.outputs::add), StateRequestHandler.unsupported(), BundleProgressHandler.unsupported());
            this.mainInput = Iterables.getOnlyElement(this.bundle.getInputReceivers().values());
        }

        @Override
        public void processElement(WindowedValue<T> element) throws Exception {
            this.mainInput.accept(element);
        }

        @Override
        public TransformResult<T> finishBundle() throws Exception {
            this.bundle.close();
            return StepTransformResult.withoutHold(this.transform).addOutput(this.outputs).build();
        }
    }
}

