/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_runners_direct_java.runners.core.construction;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_runners_core_construction_java.com.google.common.collect.Iterables;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TaggedPValue;
import org.apache.beam.sdk.values.TupleTag;

public class ReplacementOutputs {
    private ReplacementOutputs() {
    }

    public static Map<PValue, PTransformOverrideFactory.ReplacementOutput> singleton(Map<TupleTag<?>, PValue> original, PValue replacement) {
        Map.Entry<TupleTag<?>, PValue> originalElement = Iterables.getOnlyElement(original.entrySet());
        TupleTag replacementTag = (TupleTag)Iterables.getOnlyElement(replacement.expand().entrySet()).getKey();
        return Collections.singletonMap(replacement, PTransformOverrideFactory.ReplacementOutput.of((TaggedPValue)TaggedPValue.of(originalElement.getKey(), (PValue)originalElement.getValue()), (TaggedPValue)TaggedPValue.of((TupleTag)replacementTag, (PValue)replacement)));
    }

    public static Map<PValue, PTransformOverrideFactory.ReplacementOutput> tagged(Map<TupleTag<?>, PValue> original, POutput replacement) {
        HashMap originalTags = new HashMap();
        for (Map.Entry<TupleTag<?>, PValue> originalValue : original.entrySet()) {
            originalTags.put(originalValue.getKey(), TaggedPValue.of(originalValue.getKey(), (PValue)originalValue.getValue()));
        }
        ImmutableMap.Builder<PValue, PTransformOverrideFactory.ReplacementOutput> resultBuilder = ImmutableMap.builder();
        HashSet missingTags = new HashSet(originalTags.keySet());
        for (Map.Entry replacementValue : replacement.expand().entrySet()) {
            TaggedPValue mapped = (TaggedPValue)originalTags.get(replacementValue.getKey());
            Preconditions.checkArgument(mapped != null, "Missing original output for Tag %s and Value %s Between original %s and replacement %s", replacementValue.getKey(), replacementValue.getValue(), original, (Object)replacement.expand());
            resultBuilder.put((PValue)replacementValue.getValue(), PTransformOverrideFactory.ReplacementOutput.of((TaggedPValue)mapped, (TaggedPValue)TaggedPValue.of((TupleTag)((TupleTag)replacementValue.getKey()), (PValue)((PValue)replacementValue.getValue()))));
            missingTags.remove(replacementValue.getKey());
        }
        ImmutableMap<PValue, PTransformOverrideFactory.ReplacementOutput> result = resultBuilder.build();
        Preconditions.checkArgument(missingTags.isEmpty(), "Missing replacement for tags %s. Encountered tags: %s", missingTags, (Object)result.keySet());
        return result;
    }
}

