/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public abstract class ScheduledChore
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledChore.class);
    private final String name;
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    private static final long DEFAULT_INITIAL_DELAY = 0L;
    private final int period;
    private final TimeUnit timeUnit;
    private final long initialDelay;
    private ChoreServicer choreServicer;
    private long timeOfLastRun = -1L;
    private long timeOfThisRun = -1L;
    private boolean initialChoreComplete = false;
    private final Stoppable stopper;

    @InterfaceAudience.Private
    @VisibleForTesting
    protected ScheduledChore() {
        this("TestChore", null, 0, 0L, DEFAULT_TIME_UNIT);
    }

    public ScheduledChore(String name, Stoppable stopper, int period) {
        this(name, stopper, period, 0L);
    }

    public ScheduledChore(String name, Stoppable stopper, int period, long initialDelay) {
        this(name, stopper, period, initialDelay, DEFAULT_TIME_UNIT);
    }

    public ScheduledChore(String name, Stoppable stopper, int period, long initialDelay, TimeUnit unit) {
        this.name = name;
        this.stopper = stopper;
        this.period = period;
        this.initialDelay = initialDelay < 0L ? 0L : initialDelay;
        this.timeUnit = unit;
    }

    @Override
    public void run() {
        block13: {
            this.updateTimeTrackingBeforeRun();
            if (this.missedStartTime() && this.isScheduled()) {
                this.onChoreMissedStartTime();
                if (LOG.isInfoEnabled()) {
                    LOG.info("Chore: " + this.getName() + " missed its start time");
                }
            } else if (this.stopper.isStopped() || !this.isScheduled()) {
                this.cancel(false);
                this.cleanup();
                if (LOG.isInfoEnabled()) {
                    LOG.info("Chore: " + this.getName() + " was stopped");
                }
            } else {
                try {
                    long start = 0L;
                    if (LOG.isDebugEnabled()) {
                        start = System.nanoTime();
                    }
                    if (!this.initialChoreComplete) {
                        this.initialChoreComplete = this.initialChore();
                    } else {
                        this.chore();
                    }
                    if (LOG.isDebugEnabled() && start > 0L) {
                        long end = System.nanoTime();
                        LOG.debug("{} execution time: {} ms.", (Object)this.getName(), (Object)TimeUnit.NANOSECONDS.toMillis(end - start));
                    }
                }
                catch (Throwable t) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Caught error", t);
                    }
                    if (!this.stopper.isStopped()) break block13;
                    this.cancel(false);
                    this.cleanup();
                }
            }
        }
    }

    private synchronized void updateTimeTrackingBeforeRun() {
        this.timeOfLastRun = this.timeOfThisRun;
        this.timeOfThisRun = System.currentTimeMillis();
    }

    private synchronized void onChoreMissedStartTime() {
        if (this.choreServicer != null) {
            this.choreServicer.onChoreMissedStartTime(this);
        }
    }

    synchronized long getTimeBetweenRuns() {
        return this.timeOfThisRun - this.timeOfLastRun;
    }

    private synchronized boolean missedStartTime() {
        return this.isValidTime(this.timeOfLastRun) && this.isValidTime(this.timeOfThisRun) && (double)this.getTimeBetweenRuns() > this.getMaximumAllowedTimeBetweenRuns();
    }

    private double getMaximumAllowedTimeBetweenRuns() {
        return 1.5 * (double)this.timeUnit.toMillis(this.period);
    }

    private synchronized boolean isValidTime(long time) {
        return time > 0L && time <= System.currentTimeMillis();
    }

    public synchronized boolean triggerNow() {
        if (this.choreServicer != null) {
            return this.choreServicer.triggerNow(this);
        }
        return false;
    }

    synchronized void setChoreServicer(ChoreServicer service) {
        if (this.choreServicer != null && this.choreServicer != service) {
            this.choreServicer.cancelChore(this, false);
        }
        this.choreServicer = service;
        this.timeOfThisRun = -1L;
    }

    public synchronized void cancel() {
        this.cancel(true);
    }

    public synchronized void cancel(boolean mayInterruptIfRunning) {
        if (this.isScheduled()) {
            this.choreServicer.cancelChore(this, mayInterruptIfRunning);
        }
        this.choreServicer = null;
    }

    public String getName() {
        return this.name;
    }

    public Stoppable getStopper() {
        return this.stopper;
    }

    public int getPeriod() {
        return this.period;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public synchronized boolean isInitialChoreComplete() {
        return this.initialChoreComplete;
    }

    @VisibleForTesting
    synchronized ChoreServicer getChoreServicer() {
        return this.choreServicer;
    }

    @VisibleForTesting
    synchronized long getTimeOfLastRun() {
        return this.timeOfLastRun;
    }

    @VisibleForTesting
    synchronized long getTimeOfThisRun() {
        return this.timeOfThisRun;
    }

    public synchronized boolean isScheduled() {
        return this.choreServicer != null && this.choreServicer.isChoreScheduled(this);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized void choreForTesting() {
        this.chore();
    }

    protected abstract void chore();

    protected boolean initialChore() {
        return true;
    }

    protected synchronized void cleanup() {
    }

    @InterfaceAudience.Private
    public String toString() {
        return "ScheduledChore name=" + this.getName() + ", period=" + this.getPeriod() + ", unit=" + (Object)((Object)this.getTimeUnit());
    }

    static interface ChoreServicer {
        public void cancelChore(ScheduledChore var1);

        public void cancelChore(ScheduledChore var1, boolean var2);

        public boolean isChoreScheduled(ScheduledChore var1);

        public boolean triggerNow(ScheduledChore var1);

        public void onChoreMissedStartTime(ScheduledChore var1);
    }
}

