/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.client.clients;

import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.marmotta.client.ClientConfiguration;
import org.apache.marmotta.client.util.HTTPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextClient {
    private static Logger log = LoggerFactory.getLogger(ContextClient.class);
    private ClientConfiguration config;

    public ContextClient(ClientConfiguration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean delete(String uri) {
        boolean result = false;
        HttpClient httpClient = HTTPUtil.createClient(this.config);
        HttpDelete delete = new HttpDelete(uri);
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)delete);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    log.debug(uri + "cleanned");
                    result = true;
                    return result;
                }
                case 404: {
                    log.error(uri + " is not a suitable context");
                    result = false;
                }
                default: {
                    log.error("error cleanning context: {} {}", new Object[]{response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()});
                    return result;
                }
            }
        }
        catch (ClientProtocolException e) {
            log.error(e.getMessage(), (Throwable)e);
            result = false;
            return result;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            result = false;
            return result;
        }
        finally {
            delete.releaseConnection();
        }
    }
}

